/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.eventmesh.connector.jdbc;

/**
 * Represents data associated with a JDBC connector.
 */
public final class JdbcConnectData {

    /**
     * Constant representing data changes in the JDBC connector.
     */
    public static final byte DATA_CHANGES = 1;

    /**
     * Constant representing schema changes in the JDBC connector.
     */
    public static final byte SCHEMA_CHANGES = 1 << 1;

    private Payload payload = new Payload();

    private Schema schema;

    private byte type = 0;

    public JdbcConnectData() {
    }

    public JdbcConnectData(byte type) {
        this.type = type;
    }

    public Payload getPayload() {
        return payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Schema getSchema() {
        return schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public byte getType() {
        return type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void markDataChanges() {
        this.type |= DATA_CHANGES;
    }

    public void markSchemaChanges() {
        this.type |= SCHEMA_CHANGES;
    }

    public boolean isDataChanges() {
        return (this.type & DATA_CHANGES) != 0;
    }

    public boolean isSchemaChanges() {
        return (this.type & SCHEMA_CHANGES) != 0;
    }
}
