/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.common.base.Predicate;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.URIDataPuller;
import org.apache.druid.storage.google.GoogleByteSource;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.utils.CompressionUtils;

public class GoogleDataSegmentPuller
implements URIDataPuller {
    private static final Logger LOG = new Logger(GoogleDataSegmentPuller.class);
    protected final GoogleStorage storage;

    @Inject
    public GoogleDataSegmentPuller(GoogleStorage storage) {
        this.storage = storage;
    }

    FileUtils.FileCopyResult getSegmentFiles(String bucket, String path, File outDir) throws SegmentLoadingException {
        LOG.info("Pulling index at bucket[%s] path[%s] to outDir[%s]", new Object[]{bucket, path, outDir.getAbsolutePath()});
        try {
            FileUtils.mkdirp((File)outDir);
            GoogleByteSource byteSource = new GoogleByteSource(this.storage, bucket, path);
            FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)byteSource, (File)outDir, GoogleUtils::isRetryable, (boolean)false);
            LOG.info("Loaded %d bytes from [%s] to [%s]", new Object[]{result.size(), path, outDir.getAbsolutePath()});
            return result;
        }
        catch (Exception e) {
            try {
                FileUtils.deleteDirectory((File)outDir);
            }
            catch (IOException ioe) {
                LOG.warn((Throwable)ioe, "Failed to remove output directory [%s] for segment pulled from [%s]", new Object[]{outDir.getAbsolutePath(), path});
            }
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    public InputStream getInputStream(URI uri) throws IOException {
        String path = StringUtils.maybeRemoveLeadingSlash((String)uri.getPath());
        return this.storage.getInputStream(uri.getHost() != null ? uri.getHost() : uri.getAuthority(), path);
    }

    public String getVersion(URI uri) throws IOException {
        String path = StringUtils.maybeRemoveLeadingSlash((String)uri.getPath());
        return this.storage.version(uri.getHost() != null ? uri.getHost() : uri.getAuthority(), path);
    }

    public Predicate<Throwable> shouldRetryPredicate() {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable e) {
                if (e == null) {
                    return false;
                }
                if (GoogleUtils.isRetryable(e)) {
                    return true;
                }
                return this.apply(e.getCause());
            }
        };
    }
}

