/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import org.apache.druid.java.util.common.StringUtils;

public class TableId {
    public static final String DRUID_SCHEMA = "druid";
    public static final String LOOKUP_SCHEMA = "lookups";
    public static final String SYSTEM_SCHEMA = "sys";
    public static final String CATALOG_SCHEMA = "INFORMATION_SCHEMA";
    public static final String EXTERNAL_SCHEMA = "ext";
    public static final String VIEW_SCHEMA = "view";
    private final String schema;
    private final String name;

    @JsonCreator
    public TableId(@JsonProperty(value="schema") String schema, @JsonProperty(value="name") String name) {
        this.schema = schema;
        this.name = name;
    }

    public static TableId datasource(String name) {
        return new TableId(DRUID_SCHEMA, name);
    }

    public static TableId external(String name) {
        return new TableId(EXTERNAL_SCHEMA, name);
    }

    public static TableId of(String schema, String table) {
        return new TableId(schema, table);
    }

    @JsonProperty(value="schema")
    public String schema() {
        return this.schema;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    public String sqlName() {
        return StringUtils.format((String)"\"%s\".\"%s\"", (Object[])new Object[]{this.schema, this.name});
    }

    public String unquoted() {
        return StringUtils.format((String)"%s.%s", (Object[])new Object[]{this.schema, this.name});
    }

    public String toString() {
        return this.sqlName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TableId other = (TableId)o;
        return Objects.equal((Object)this.schema, (Object)other.schema) && Objects.equal((Object)this.name, (Object)other.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schema, this.name});
    }
}

