/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.DeepStoragePartitionStat;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.joda.time.Interval;

public class DeepStorageIntermediaryDataManager
implements IntermediaryDataManager {
    public static final String SHUFFLE_DATA_DIR_PREFIX = "shuffle-data";
    private final DataSegmentPusher dataSegmentPusher;

    @Inject
    public DeepStorageIntermediaryDataManager(DataSegmentPusher dataSegmentPusher) {
        this.dataSegmentPusher = dataSegmentPusher;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public DataSegment addSegment(String supervisorTaskId, String subTaskId, DataSegment segment, File segmentDir) throws IOException {
        if (!(segment.getShardSpec() instanceof BucketNumberedShardSpec)) {
            throw new IAE("Invalid shardSpec type. Expected [%s] but got [%s]", new Object[]{BucketNumberedShardSpec.class.getName(), segment.getShardSpec().getClass().getName()});
        }
        BucketNumberedShardSpec bucketNumberedShardSpec = (BucketNumberedShardSpec)segment.getShardSpec();
        String partitionFilePath = this.getPartitionFilePath(supervisorTaskId, subTaskId, segment.getInterval(), bucketNumberedShardSpec.getBucketId());
        return this.dataSegmentPusher.pushToPath(segmentDir, segment, "shuffle-data/" + partitionFilePath);
    }

    @Override
    public DeepStoragePartitionStat generatePartitionStat(TaskToolbox toolbox, DataSegment segment) {
        return new DeepStoragePartitionStat(segment.getInterval(), (BucketNumberedShardSpec)segment.getShardSpec(), segment.getLoadSpec());
    }

    @Override
    @Nullable
    public Optional<ByteSource> findPartitionFile(String supervisorTaskId, String subTaskId, Interval interval, int bucketId) {
        throw new UnsupportedOperationException("Not supported, get partition file using segment loadspec");
    }

    @Override
    public void deletePartitions(String supervisorTaskId) {
        throw new UnsupportedOperationException("Not supported");
    }
}

