/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="default", value=DefaultLagAggregator.class)})
public interface LagAggregator {
    public static final LagAggregator DEFAULT = new DefaultLagAggregator();

    public <PartitionIdType> LagStats aggregate(Map<PartitionIdType, Long> var1);

    public static class DefaultLagAggregator
    implements LagAggregator {
        @Override
        public <PartitionIdType> LagStats aggregate(Map<PartitionIdType, Long> partitionLags) {
            long maxLag = 0L;
            long totalLag = 0L;
            for (long lag : partitionLags.values()) {
                if (lag > maxLag) {
                    maxLag = lag;
                }
                totalLag += Math.max(lag, 0L);
            }
            long avgLag = partitionLags.isEmpty() ? 0L : totalLag / (long)partitionLags.size();
            return new LagStats(maxLag, totalLag, avgLag);
        }
    }
}

