/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;

public class DruidUnnestRel
extends DruidRel<DruidUnnestRel> {
    private static final String FIELD_NAME = "UNNEST";
    private final RexNode inputRexNode;
    private final Filter unnestFilter;

    private DruidUnnestRel(RelOptCluster cluster, RelTraitSet traits, RexNode inputRexNode, Filter unnestFilter, PlannerContext plannerContext) {
        super(cluster, traits, plannerContext);
        this.inputRexNode = inputRexNode;
        this.unnestFilter = unnestFilter;
    }

    public Filter getUnnestFilter() {
        return this.unnestFilter;
    }

    public static DruidUnnestRel create(RelOptCluster cluster, RelTraitSet traits, RexNode unnestRexNode, PlannerContext plannerContext) {
        if (!RelOptUtil.InputFinder.bits((RexNode)unnestRexNode).isEmpty()) {
            throw new ISE("Expression must not include field references", new Object[0]);
        }
        return new DruidUnnestRel(cluster, traits, unnestRexNode, null, plannerContext);
    }

    public RelNode accept(RexShuttle shuttle) {
        RexNode newInputRexNode = shuttle.apply(this.inputRexNode);
        if (newInputRexNode == this.inputRexNode) {
            return this;
        }
        return new DruidUnnestRel(this.getCluster(), this.getTraitSet(), newInputRexNode, this.unnestFilter, this.getPlannerContext());
    }

    public RexNode getInputRexNode() {
        return this.inputRexNode;
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return null;
    }

    @Override
    public DruidUnnestRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        throw new UnsupportedOperationException();
    }

    public DruidUnnestRel withFilter(Filter f) {
        return new DruidUnnestRel(this.getCluster(), this.getTraitSet(), this.inputRexNode, f, this.getPlannerContext());
    }

    public DruidUnnestRel withUnnestRexNode(RexNode newInputRexNode) {
        return new DruidUnnestRel(this.getCluster(), this.getTraitSet(), newInputRexNode, this.unnestFilter, this.getPlannerContext());
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        throw new CannotBuildQueryException("Cannot execute UNNEST directly");
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        throw new CannotBuildQueryException("Cannot execute UNNEST directly");
    }

    @Override
    @Nullable
    public DruidUnnestRel asDruidConvention() {
        return new DruidUnnestRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.inputRexNode, this.unnestFilter, this.getPlannerContext());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("expr", (Object)this.inputRexNode).item("filter", (Object)this.unnestFilter);
    }

    @Override
    public Set<String> getDataSourceNames() {
        return Collections.emptySet();
    }

    protected RelDataType deriveRowType() {
        return Uncollect.deriveUncollectRowType((RelNode)LogicalValues.createEmpty((RelOptCluster)this.getCluster(), (RelDataType)RexUtil.createStructType((RelDataTypeFactory)this.getCluster().getTypeFactory(), (List)ImmutableList.of((Object)this.inputRexNode), null, (SqlValidatorUtil.Suggester)SqlValidatorUtil.F_SUGGESTER)), (boolean)false, Collections.emptyList());
    }
}

