/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.hook.DruidHookDispatcher;

public class PlannerToolbox {
    protected final DruidOperatorTable operatorTable;
    protected final ExprMacroTable macroTable;
    protected final JoinableFactoryWrapper joinableFactoryWrapper;
    protected final ObjectMapper jsonMapper;
    protected final PlannerConfig plannerConfig;
    protected final DruidSchemaCatalog rootSchema;
    protected final CatalogResolver catalog;
    protected final String druidSchemaName;
    protected final CalciteRulesManager calciteRuleManager;
    protected final AuthorizerMapper authorizerMapper;
    protected final AuthConfig authConfig;
    protected final PolicyEnforcer policyEnforcer;
    protected final DruidHookDispatcher hookDispatcher;

    public PlannerToolbox(DruidOperatorTable operatorTable, ExprMacroTable macroTable, ObjectMapper jsonMapper, PlannerConfig plannerConfig, DruidSchemaCatalog rootSchema, JoinableFactoryWrapper joinableFactoryWrapper, CatalogResolver catalog, String druidSchemaName, CalciteRulesManager calciteRuleManager, AuthorizerMapper authorizerMapper, AuthConfig authConfig, PolicyEnforcer policyEnforcer, DruidHookDispatcher hookDispatcher) {
        this.operatorTable = operatorTable;
        this.macroTable = macroTable;
        this.jsonMapper = jsonMapper;
        this.plannerConfig = (PlannerConfig)Preconditions.checkNotNull((Object)plannerConfig, (Object)"plannerConfig");
        this.rootSchema = rootSchema;
        this.joinableFactoryWrapper = joinableFactoryWrapper;
        this.catalog = catalog;
        this.druidSchemaName = druidSchemaName;
        this.calciteRuleManager = calciteRuleManager;
        this.authorizerMapper = authorizerMapper;
        this.authConfig = authConfig;
        this.policyEnforcer = policyEnforcer;
        this.hookDispatcher = hookDispatcher;
    }

    public DruidOperatorTable operatorTable() {
        return this.operatorTable;
    }

    public ExprMacroTable exprMacroTable() {
        return this.macroTable;
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public DruidSchemaCatalog rootSchema() {
        return this.rootSchema;
    }

    public JoinableFactoryWrapper joinableFactoryWrapper() {
        return this.joinableFactoryWrapper;
    }

    public CatalogResolver catalogResolver() {
        return this.catalog;
    }

    public String druidSchemaName() {
        return this.druidSchemaName;
    }

    public CalciteRulesManager calciteRuleManager() {
        return this.calciteRuleManager;
    }

    public PlannerConfig plannerConfig() {
        return this.plannerConfig;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public PolicyEnforcer getPolicyEnforcer() {
        return this.policyEnforcer;
    }

    public DruidHookDispatcher getHookDispatcher() {
        return this.hookDispatcher;
    }
}

