/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ScalarInArrayOperatorConversion;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class SearchOperatorConversion
implements SqlOperatorConversion {
    private static final RexBuilder REX_BUILDER = new RexBuilder(DruidTypeSystem.TYPE_FACTORY);

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.SEARCH;
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        return Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, SearchOperatorConversion.expandSearch((RexCall)rexNode, REX_BUILDER, plannerContext.queryContext().getInFunctionThreshold()));
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return Expressions.toDruidExpression(plannerContext, rowSignature, SearchOperatorConversion.expandSearch((RexCall)rexNode, REX_BUILDER, plannerContext.queryContext().getInFunctionExprThreshold()));
    }

    public static RexNode expandSearch(RexCall call, RexBuilder rexBuilder, int scalarInArrayThreshold) {
        List notInPoints;
        RexNode notInRexNode;
        RexNode arg = (RexNode)call.operands.get(0);
        RexLiteral sargRex = (RexLiteral)call.operands.get(1);
        Sarg sarg = (Sarg)sargRex.getValueAs(Sarg.class);
        if (sarg.isAll() || sarg.isNone()) {
            return RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)call);
        }
        ArrayList<RexNode> rangeRexNodes = new ArrayList<RexNode>();
        if (sarg.isPoints()) {
            notInRexNode = null;
            notInPoints = Collections.emptyList();
        } else {
            RangeSet complement = sarg.rangeSet.complement();
            notInPoints = SearchOperatorConversion.getPoints(complement);
            notInRexNode = SearchOperatorConversion.makeIn(arg, notInPoints, sargRex.getType(), true, notInPoints.size() >= scalarInArrayThreshold, rexBuilder);
        }
        List inPoints = sarg.pointCount == 0 ? Collections.emptyList() : SearchOperatorConversion.getPoints(sarg.rangeSet);
        RexNode inRexNode = SearchOperatorConversion.makeIn(arg, inPoints, sargRex.getType(), false, inPoints.size() >= scalarInArrayThreshold, rexBuilder);
        if (inRexNode != null) {
            rangeRexNodes.add(inRexNode);
        }
        if (!sarg.isPoints() && !sarg.isComplementedPoints()) {
            TreeRangeSet remainderRanges = TreeRangeSet.create();
            for (Range range : sarg.rangeSet.asRanges()) {
                if (RangeSets.isPoint((Range)range)) continue;
                remainderRanges.add(range);
            }
            for (Comparable notInPoint : notInPoints) {
                remainderRanges.add(Range.singleton((Comparable)notInPoint));
            }
            if (!remainderRanges.encloses(Range.all()) && !remainderRanges.isEmpty()) {
                Sarg remainderSarg = Sarg.of((RexUnknownAs)RexUnknownAs.UNKNOWN, (RangeSet)remainderRanges);
                RexNode remainderRexNode = RexUtil.sargRef((RexBuilder)rexBuilder, (RexNode)arg, (Sarg)remainderSarg, (RelDataType)sargRex.getType(), (RexUnknownAs)RexUnknownAs.UNKNOWN);
                if (remainderRexNode.isA(SqlKind.OR)) {
                    rangeRexNodes.addAll(((RexCall)remainderRexNode).getOperands());
                } else {
                    rangeRexNodes.add(remainderRexNode);
                }
            }
        }
        RexNode retVal = null;
        if (!rangeRexNodes.isEmpty()) {
            retVal = RexUtil.composeDisjunction((RexBuilder)rexBuilder, rangeRexNodes);
        }
        if (notInRexNode != null) {
            RexNode rexNode = retVal = retVal == null ? notInRexNode : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{retVal, notInRexNode});
        }
        if (sarg.nullAs == RexUnknownAs.TRUE) {
            retVal = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg}), retVal});
        } else if (sarg.nullAs == RexUnknownAs.FALSE) {
            retVal = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{arg}), retVal});
        }
        return retVal;
    }

    @Nullable
    public static RexNode makeIn(RexNode arg, Collection<? extends Comparable> pointObjects, RelDataType pointType, boolean negate, boolean useScalarInArray, RexBuilder rexBuilder) {
        ImmutableList points = ImmutableList.copyOf((Iterable)Iterables.transform(pointObjects, point -> rexBuilder.makeLiteral(point, pointType, false, false)));
        if (points.isEmpty()) {
            return null;
        }
        if (points.size() == 1) {
            RexNode point2 = (RexNode)Iterables.getOnlyElement((Iterable)points);
            if (RexUtil.isNullLiteral((RexNode)point2, (boolean)true)) {
                return rexBuilder.makeCall((SqlOperator)(negate ? SqlStdOperatorTable.IS_NOT_NULL : SqlStdOperatorTable.IS_NULL), new RexNode[]{arg});
            }
            return rexBuilder.makeCall((SqlOperator)(negate ? SqlStdOperatorTable.NOT_EQUALS : SqlStdOperatorTable.EQUALS), new RexNode[]{arg, point2});
        }
        RexNode retVal = useScalarInArray ? rexBuilder.makeCall((SqlOperator)ScalarInArrayOperatorConversion.SQL_FUNCTION, new RexNode[]{arg, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, (List)points)}) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)points, point -> {
            if (RexUtil.isNullLiteral((RexNode)point, (boolean)true)) {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{arg});
            }
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{arg, point});
        })));
        if (negate) {
            retVal = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{retVal});
        }
        return retVal;
    }

    private static <T extends Comparable<T>> List<T> getPoints(RangeSet<T> rangeSet) {
        ArrayList<Comparable> points = new ArrayList<Comparable>();
        for (Range range : rangeSet.asRanges()) {
            if (!RangeSets.isPoint((Range)range)) continue;
            points.add(range.lowerEndpoint());
        }
        return points;
    }
}

