/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryResourceId;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SubqueryQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.groupby.DefaultGroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByQueryResources;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.ResultRowObjectMapperDecoratorUtil;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.nested.StructuredData;
import org.joda.time.DateTime;

public class GroupByQueryQueryToolChest
extends QueryToolChest<ResultRow, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<ResultRow> TYPE_REFERENCE = new TypeReference<ResultRow>(){};
    private final GroupingEngine groupingEngine;
    private final GroupByQueryConfig queryConfig;
    private final GroupByQueryMetricsFactory queryMetricsFactory;
    private final GroupByResourcesReservationPool groupByResourcesReservationPool;
    private final GroupByStatsProvider groupByStatsProvider;

    @VisibleForTesting
    public GroupByQueryQueryToolChest(GroupingEngine groupingEngine, GroupByResourcesReservationPool groupByResourcesReservationPool) {
        this(groupingEngine, (Supplier<GroupByQueryConfig>)((Supplier)GroupByQueryConfig::new), DefaultGroupByQueryMetricsFactory.instance(), groupByResourcesReservationPool, new GroupByStatsProvider());
    }

    @VisibleForTesting
    public GroupByQueryQueryToolChest(GroupingEngine groupingEngine, GroupByResourcesReservationPool groupByResourcesReservationPool, GroupByStatsProvider groupByStatsProvider) {
        this(groupingEngine, (Supplier<GroupByQueryConfig>)((Supplier)GroupByQueryConfig::new), DefaultGroupByQueryMetricsFactory.instance(), groupByResourcesReservationPool, groupByStatsProvider);
    }

    @Inject
    public GroupByQueryQueryToolChest(GroupingEngine groupingEngine, Supplier<GroupByQueryConfig> queryConfigSupplier, GroupByQueryMetricsFactory queryMetricsFactory, @Merging GroupByResourcesReservationPool groupByResourcesReservationPool, GroupByStatsProvider groupByStatsProvider) {
        this.groupingEngine = groupingEngine;
        this.queryConfig = (GroupByQueryConfig)queryConfigSupplier.get();
        this.queryMetricsFactory = queryMetricsFactory;
        this.groupByResourcesReservationPool = groupByResourcesReservationPool;
        this.groupByStatsProvider = groupByStatsProvider;
    }

    @Override
    public QueryRunner<ResultRow> mergeResults(QueryRunner<ResultRow> runner) {
        return this.mergeResults(runner, true);
    }

    @Override
    public QueryRunner<ResultRow> mergeResults(QueryRunner<ResultRow> runner, boolean willMergeRunner) {
        return (queryPlus, responseContext) -> {
            if (queryPlus.getQuery().context().isBySegment()) {
                return runner.run(queryPlus, responseContext);
            }
            GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
            return this.initAndMergeGroupByResults(groupByQuery, runner, responseContext, willMergeRunner);
        };
    }

    @Override
    public BinaryOperator<ResultRow> createMergeFn(Query<ResultRow> query) {
        return this.groupingEngine.createMergeFn(query);
    }

    @Override
    public Comparator<ResultRow> createResultComparator(Query<ResultRow> query) {
        return this.groupingEngine.createResultComparator(query);
    }

    private Sequence<ResultRow> initAndMergeGroupByResults(GroupByQuery query, QueryRunner<ResultRow> runner, ResponseContext context, boolean willMergeRunner) {
        QueryResourceId queryResourceId = query.context().getQueryResourceId();
        GroupByStatsProvider.PerQueryStats perQueryStats = this.groupByStatsProvider.getPerQueryStatsContainer(query.context().getQueryResourceId());
        this.groupByResourcesReservationPool.reserve(queryResourceId, query, willMergeRunner, perQueryStats);
        GroupByQueryResources resource = this.groupByResourcesReservationPool.fetch(queryResourceId);
        if (resource == null) {
            throw DruidException.defensive("Did not associate any resources with the given query resource id [%s]", queryResourceId);
        }
        try {
            Closer closer = Closer.create();
            Sequence<ResultRow> mergedSequence = this.mergeGroupByResults(query, resource, runner, context, closer, perQueryStats);
            closer.register(() -> this.groupByResourcesReservationPool.clean(queryResourceId));
            closer.register(() -> this.groupByStatsProvider.closeQuery(query.context().getQueryResourceId()));
            return Sequences.withBaggage(mergedSequence, closer);
        }
        catch (Exception e) {
            resource.close();
            throw e;
        }
    }

    private Sequence<ResultRow> mergeGroupByResults(GroupByQuery query, GroupByQueryResources resource, QueryRunner<ResultRow> runner, ResponseContext context, Closer closer, GroupByStatsProvider.PerQueryStats perQueryStats) {
        if (GroupByQueryQueryToolChest.isNestedQueryPushDown(query)) {
            return this.mergeResultsWithNestedQueryPushDown(query, resource, runner, context, perQueryStats);
        }
        return this.mergeGroupByResultsWithoutPushDown(query, resource, runner, context, closer, perQueryStats);
    }

    private Sequence<ResultRow> mergeGroupByResultsWithoutPushDown(GroupByQuery query, GroupByQueryResources resource, QueryRunner<ResultRow> runner, ResponseContext context, Closer closer, GroupByStatsProvider.PerQueryStats perQueryStats) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                TreeMap<String, Object> subqueryContext = new TreeMap<String, Object>();
                if (query.getContext() != null) {
                    for (Map.Entry<String, Object> entry : query.getContext().entrySet()) {
                        if (entry.getValue() == null) continue;
                        subqueryContext.put(entry.getKey(), entry.getValue());
                    }
                }
                if (((QueryDataSource)dataSource).getQuery().getContext() != null) {
                    subqueryContext.putAll(((QueryDataSource)dataSource).getQuery().getContext());
                }
                subqueryContext.put("sortByDimsFirst", false);
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery().withOverriddenContext(subqueryContext);
                closer.register(() -> this.groupByStatsProvider.closeQuery(subquery.context().getQueryResourceId()));
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            Sequence<ResultRow> subqueryResult = this.mergeGroupByResults(subquery, resource, runner, context, closer, perQueryStats);
            Sequence<ResultRow> finalizingResults = this.finalizeSubqueryResults(subqueryResult, subquery);
            if (query.getSubtotalsSpec() != null) {
                return this.groupingEngine.processSubtotalsSpec(query, resource, this.groupingEngine.processSubqueryResult(subquery, query, resource, finalizingResults, false, perQueryStats), perQueryStats);
            }
            return this.groupingEngine.applyPostProcessing(this.groupingEngine.processSubqueryResult(subquery, query, resource, finalizingResults, false, perQueryStats), query);
        }
        if (query.getSubtotalsSpec() != null) {
            return this.groupingEngine.processSubtotalsSpec(query, resource, this.groupingEngine.mergeResults(runner, query.withSubtotalsSpec(null), context), perQueryStats);
        }
        return this.groupingEngine.applyPostProcessing(this.groupingEngine.mergeResults(runner, query, context), query);
    }

    private Sequence<ResultRow> mergeResultsWithNestedQueryPushDown(GroupByQuery query, GroupByQueryResources resource, QueryRunner<ResultRow> runner, ResponseContext context, GroupByStatsProvider.PerQueryStats perQueryStats) {
        Sequence<ResultRow> pushDownQueryResults = this.groupingEngine.mergeResults(runner, query, context);
        Sequence<ResultRow> finalizedResults = this.finalizeSubqueryResults(pushDownQueryResults, query);
        GroupByQuery rewrittenQuery = this.rewriteNestedQueryForPushDown(query);
        return this.groupingEngine.applyPostProcessing(this.groupingEngine.processSubqueryResult(query, rewrittenQuery, resource, finalizedResults, true, perQueryStats), query);
    }

    @VisibleForTesting
    GroupByQuery rewriteNestedQueryForPushDown(GroupByQuery query) {
        return query.withAggregatorSpecs(Lists.transform(query.getAggregatorSpecs(), agg -> agg.getCombiningFactory())).withDimensionSpecs(Lists.transform(query.getDimensions(), dim -> new DefaultDimensionSpec(dim.getOutputName(), dim.getOutputName(), dim.getOutputType())));
    }

    private Sequence<ResultRow> finalizeSubqueryResults(Sequence<ResultRow> subqueryResult, GroupByQuery subquery) {
        Sequence<ResultRow> finalizingResults = subquery.context().isFinalize(false) ? new MappedSequence<ResultRow, ResultRow>(subqueryResult, arg_0 -> this.makePreComputeManipulatorFn(subquery, MetricManipulatorFns.finalizing()).apply(arg_0)) : subqueryResult;
        return finalizingResults;
    }

    public static boolean isNestedQueryPushDown(GroupByQuery q) {
        return q.getDataSource() instanceof QueryDataSource && q.context().getBoolean("forcePushDownNestedQuery", false) && q.getSubtotalsSpec() == null;
    }

    public GroupByQueryMetrics makeMetrics(GroupByQuery query) {
        GroupByQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<ResultRow, ResultRow> makePreComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        if (MetricManipulatorFns.identity().equals(fn)) {
            return Functions.identity();
        }
        return row -> {
            ResultRow newRow = row.copy();
            List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
            int aggregatorStart = query.getResultRowAggregatorStart();
            for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                AggregatorFactory agg = aggregatorSpecs.get(i);
                newRow.set(aggregatorStart + i, fn.manipulate(agg, row.get(aggregatorStart + i)));
            }
            return newRow;
        };
    }

    @Override
    public Function<ResultRow, ResultRow> makePostComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        BitSet optimizedDims = GroupByQueryQueryToolChest.extractionsToRewrite(query);
        Function<ResultRow, ResultRow> preCompute = this.makePreComputeManipulatorFn(query, fn);
        if (optimizedDims.isEmpty()) {
            return preCompute;
        }
        List<DimensionSpec> dimensions = query.getDimensions();
        ArrayList<ExtractionFn> extractionFns = new ArrayList<ExtractionFn>(dimensions.size());
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionSpec dimensionSpec = dimensions.get(i);
            ExtractionFn extractionFnToAdd = optimizedDims.get(i) ? dimensionSpec.getExtractionFn() : null;
            extractionFns.add(extractionFnToAdd);
        }
        int dimensionStart = query.getResultRowDimensionStart();
        return row -> {
            ResultRow newRow = (ResultRow)preCompute.apply(row);
            if (newRow == row) {
                newRow = row.copy();
            }
            int i = optimizedDims.nextSetBit(0);
            while (i >= 0) {
                newRow.set(dimensionStart + i, ((ExtractionFn)extractionFns.get(i)).apply(newRow.get(dimensionStart + i)));
                i = optimizedDims.nextSetBit(i + 1);
            }
            return newRow;
        };
    }

    @Override
    public TypeReference<ResultRow> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public ObjectMapper decorateObjectMapper(ObjectMapper objectMapper, GroupByQuery query) {
        return ResultRowObjectMapperDecoratorUtil.decorateObjectMapper(objectMapper, query, this.queryConfig);
    }

    @Override
    public QueryRunner<ResultRow> preMergeQueryDecoration(final QueryRunner<ResultRow> runner) {
        return new SubqueryQueryRunner<ResultRow>(new QueryRunner<ResultRow>(){

            @Override
            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
                ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
                BitSet optimizedDimensions = GroupByQueryQueryToolChest.extractionsToRewrite(groupByQuery);
                List<DimensionSpec> dimensions = groupByQuery.getDimensions();
                for (int i = 0; i < dimensions.size(); ++i) {
                    DimensionSpec dimensionSpec = dimensions.get(i);
                    if (optimizedDimensions.get(i)) {
                        dimensionSpecs.add(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName()));
                        continue;
                    }
                    dimensionSpecs.add(dimensionSpec);
                }
                return runner.run(queryPlus.withQuery(groupByQuery.withDimensionSpecs(dimensionSpecs)), responseContext);
            }
        });
    }

    @Override
    @Nullable
    public CacheStrategy<ResultRow, Object, GroupByQuery> getCacheStrategy(GroupByQuery query) {
        return this.getCacheStrategy(query, (ObjectMapper)null);
    }

    @Override
    public CacheStrategy<ResultRow, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query, final @Nullable ObjectMapper mapper) {
        for (DimensionSpec dimension : query.getDimensions()) {
            if (!dimension.getOutputType().is(ValueType.COMPLEX) || dimension.getOutputType().equals(ColumnType.NESTED_DATA) || mapper != null) continue;
            throw DruidException.defensive("Cannot deserialize complex dimension of type[%s] from result cache if object mapper is not provided", dimension.getOutputType().getComplexTypeName());
        }
        final Class[] dimensionClasses = GroupByQueryQueryToolChest.createDimensionClasses(query);
        return new CacheStrategy<ResultRow, Object, GroupByQuery>(){
            private static final byte CACHE_STRATEGY_VERSION = 1;
            private final List<AggregatorFactory> aggs;
            private final List<DimensionSpec> dims;
            {
                this.aggs = query.getAggregatorSpecs();
                this.dims = query.getDimensions();
            }

            @Override
            public boolean isCacheable(GroupByQuery query2, boolean willMergeRunners, boolean segmentLevel) {
                return willMergeRunners || !segmentLevel;
            }

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(20).appendByte((byte)1).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheables(query2.getDimensions()).appendCacheable(query2.getVirtualColumns());
                if (query2.isApplyLimitPushDown()) {
                    builder.appendCacheable(query2.getLimitSpec());
                }
                return builder.build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(GroupByQuery query2) {
                CacheKeyBuilder builder = new CacheKeyBuilder(20).appendByte((byte)1).appendCacheable(query2.getGranularity()).appendCacheable(query2.getDimFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheables(query2.getDimensions()).appendCacheable(query2.getVirtualColumns()).appendCacheable(query2.getHavingSpec()).appendCacheable(query2.getLimitSpec()).appendCacheables(query2.getPostAggregatorSpecs());
                if (query2.getSubtotalsSpec() != null && !query2.getSubtotalsSpec().isEmpty()) {
                    for (List<String> subTotalSpec : query2.getSubtotalsSpec()) {
                        builder.appendStrings(subTotalSpec);
                    }
                }
                return builder.build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<ResultRow, Object> prepareForCache(final boolean isResultLevelCache) {
                final boolean resultRowHasTimestamp = query.getResultRowHasTimestamp();
                return new Function<ResultRow, Object>(){

                    public Object apply(ResultRow resultRow) {
                        int i;
                        ArrayList<Object> retVal = new ArrayList<Object>(1 + dims.size() + aggs.size());
                        int inPos = 0;
                        if (resultRowHasTimestamp) {
                            retVal.add(resultRow.getLong(inPos++));
                        } else {
                            retVal.add(query.getUniversalTimestamp().getMillis());
                        }
                        for (i = 0; i < dims.size(); ++i) {
                            retVal.add(resultRow.get(inPos++));
                        }
                        for (i = 0; i < aggs.size(); ++i) {
                            retVal.add(resultRow.get(inPos++));
                        }
                        if (isResultLevelCache) {
                            for (i = 0; i < query.getPostAggregatorSpecs().size(); ++i) {
                                retVal.add(resultRow.get(inPos++));
                            }
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, ResultRow> pullFromCache(final boolean isResultLevelCache) {
                final boolean resultRowHasTimestamp = query.getResultRowHasTimestamp();
                final int dimensionStart = query.getResultRowDimensionStart();
                final int aggregatorStart = query.getResultRowAggregatorStart();
                final int postAggregatorStart = query.getResultRowPostAggregatorStart();
                return new Function<Object, ResultRow>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public ResultRow apply(Object input) {
                        Iterator<Object> results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        int size = isResultLevelCache ? query.getResultRowSizeWithPostAggregators() : query.getResultRowSizeWithoutPostAggregators();
                        ResultRow resultRow = ResultRow.create(size);
                        if (resultRowHasTimestamp) {
                            resultRow.set(0, timestamp.getMillis());
                        }
                        Iterator<DimensionSpec> dimsIter = dims.iterator();
                        int dimPos = 0;
                        while (dimsIter.hasNext() && results.hasNext()) {
                            DimensionSpec dimensionSpec = dimsIter.next();
                            Object dimensionObject = results.next();
                            ColumnType outputType = dimensionSpec.getOutputType();
                            Object dimensionObjectCasted = outputType.is(ValueType.COMPLEX) ? (outputType.equals(ColumnType.NESTED_DATA) ? StructuredData.wrap(dimensionObject) : mapper.convertValue(dimensionObject, dimensionClasses[dimPos])) : DimensionHandlerUtils.convertObjectToType(dimensionObject, dimensionSpec.getOutputType());
                            resultRow.set(dimensionStart + dimPos, dimensionObjectCasted);
                            ++dimPos;
                        }
                        CacheStrategy.fetchAggregatorsFromCache(aggs, results, isResultLevelCache, (aggName, aggPosition, aggValueObject) -> resultRow.set(aggregatorStart + aggPosition, aggValueObject));
                        if (isResultLevelCache) {
                            for (int postPos = 0; postPos < query.getPostAggregatorSpecs().size(); ++postPos) {
                                if (!results.hasNext()) {
                                    throw DruidException.defensive("Ran out of objects while reading postaggs from cache!", new Object[0]);
                                }
                                resultRow.set(postAggregatorStart + postPos, results.next());
                            }
                        }
                        if (dimsIter.hasNext() || results.hasNext()) {
                            throw new ISE("Found left over objects while reading from cache!! dimsIter[%s] results[%s]", dimsIter.hasNext(), results.hasNext());
                        }
                        return resultRow;
                    }
                };
            }
        };
    }

    @Override
    public boolean canPerformSubquery(Query<?> subquery) {
        Query current = subquery;
        while (current != null) {
            if (!(current instanceof GroupByQuery)) {
                return false;
            }
            if (current.getDataSource() instanceof QueryDataSource) {
                current = ((QueryDataSource)current.getDataSource()).getQuery();
                continue;
            }
            current = null;
        }
        return true;
    }

    @Override
    public RowSignature resultArraySignature(GroupByQuery query) {
        return query.getResultRowSignature();
    }

    @Override
    public Sequence<Object[]> resultsAsArrays(GroupByQuery query, Sequence<ResultRow> resultSequence) {
        return resultSequence.map(ResultRow::getArray);
    }

    @Override
    public Optional<Sequence<FrameSignaturePair>> resultsAsFrames(GroupByQuery query, Sequence<ResultRow> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes) {
        RowSignature rowSignature = query.getResultRowSignature(query.context().isFinalize(true) ? RowSignature.Finalization.YES : RowSignature.Finalization.NO);
        RowSignature modifiedRowSignature = useNestedForUnknownTypes ? FrameWriterUtils.replaceUnknownTypesWithNestedColumns(rowSignature) : rowSignature;
        FrameCursorUtils.throwIfColumnsHaveUnknownType(modifiedRowSignature);
        FrameWriterFactory frameWriterFactory = FrameWriters.makeColumnBasedFrameWriterFactory(memoryAllocatorFactory, modifiedRowSignature, new ArrayList<KeyColumn>());
        Pair<Cursor, Closeable> cursorAndCloseable = IterableRowsCursorHelper.getCursorFromSequence(this.resultsAsArrays(query, resultSequence), rowSignature);
        Cursor cursor = (Cursor)cursorAndCloseable.lhs;
        Closeable closeble = (Closeable)cursorAndCloseable.rhs;
        Sequence<Frame> frames = FrameCursorUtils.cursorToFramesSequence(cursor, frameWriterFactory).withBaggage(closeble);
        return Optional.of(frames.map(frame -> new FrameSignaturePair((Frame)frame, modifiedRowSignature)));
    }

    private static BitSet extractionsToRewrite(GroupByQuery query) {
        BitSet retVal = new BitSet();
        List<DimensionSpec> dimensions = query.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            DimensionSpec dimensionSpec = dimensions.get(i);
            if (dimensionSpec.getExtractionFn() == null || !ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)dimensionSpec.getExtractionFn().getExtractionType())) continue;
            retVal.set(i);
        }
        return retVal;
    }

    private static Class<?>[] createDimensionClasses(GroupByQuery query) {
        List<DimensionSpec> queryDimensions = query.getDimensions();
        Class[] classes = new Class[queryDimensions.size()];
        for (int i = 0; i < queryDimensions.size(); ++i) {
            ColumnType dimensionOutputType = queryDimensions.get(i).getOutputType();
            if (dimensionOutputType.is(ValueType.COMPLEX)) {
                NullableTypeStrategy nullableTypeStrategy = dimensionOutputType.getNullableStrategy();
                if (!nullableTypeStrategy.groupable()) {
                    throw DruidException.defensive("Ungroupable dimension [%s] with type [%s] found in the query.", queryDimensions.get(i).getDimension(), dimensionOutputType);
                }
                classes[i] = nullableTypeStrategy.getClazz();
                continue;
            }
            classes[i] = Object.class;
        }
        return classes;
    }
}

