/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;

public abstract class FastLineIterator<T>
implements CloseableIterator<T> {
    static final int BUFFER_SIZE = 512;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream source;
    private ByteBuffer buffer;
    private int lineStart = 0;
    private int position = 0;
    private int limit = 0;
    private boolean endOfStream;
    private T nextLine;
    private static final long LF_REPEAT = FastLineIterator.firstOccurrencePattern((byte)10);

    protected FastLineIterator(InputStream source) {
        this(source, new byte[512]);
    }

    protected FastLineIterator(InputStream source, byte[] buffer) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)buffer);
        this.source = source;
        this.nextLine = null;
        this.setBuffer(buffer);
    }

    @Override
    public void close() throws IOException {
        this.nextLine = null;
        this.buffer = null;
        this.source.close();
    }

    @Override
    public boolean hasNext() {
        if (this.nextLine != null) {
            return true;
        }
        this.nextLine = this.readNextLine();
        return this.nextLine != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more lines");
        }
        T result = this.nextLine;
        this.nextLine = null;
        return result;
    }

    private T readNextLine() {
        while (!this.endOfStream) {
            while (this.position < this.limit - 8) {
                long w = this.buffer.getLong(this.position);
                int index = FastLineIterator.firstOccurrence(w, LF_REPEAT);
                if (index < 8) {
                    this.position += index;
                    return this.readLineFromBuffer();
                }
                this.position += 8;
            }
            while (this.position < this.limit) {
                if (this.buffer.get(this.position) == 10) {
                    return this.readLineFromBuffer();
                }
                ++this.position;
            }
            int available = this.buffer.capacity() - this.limit;
            if (available == 0) {
                int currentLength = this.limit - this.lineStart;
                if (this.lineStart == 0) {
                    byte[] newBuf = new byte[this.buffer.capacity() * 2];
                    System.arraycopy(this.buffer.array(), this.lineStart, newBuf, 0, currentLength);
                    this.setBuffer(newBuf);
                } else {
                    System.arraycopy(this.buffer.array(), this.lineStart, this.buffer.array(), 0, currentLength);
                }
                this.position -= this.lineStart;
                this.limit -= this.lineStart;
                this.lineStart = 0;
            }
            try {
                int bytesRead = this.source.read(this.buffer.array(), this.limit, this.buffer.capacity() - this.limit);
                if (bytesRead < 0) {
                    this.endOfStream = true;
                    return this.readLineFromBuffer();
                }
                this.limit += bytesRead;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.readLineFromBuffer();
    }

    @Nullable
    private T readLineFromBuffer() {
        int lineEnd;
        boolean isLf;
        while (this.position < this.limit && this.buffer.get(this.position) != 10) {
            ++this.position;
        }
        boolean bl = isLf = this.position < this.limit && this.buffer.get(this.position) == 10;
        if (isLf && this.position > this.lineStart && this.buffer.get(this.position - 1) == 13) {
            lineEnd = this.position - 1;
        } else if (isLf) {
            lineEnd = this.position;
        } else if (this.endOfStream) {
            lineEnd = this.position;
        } else {
            throw DruidException.defensive("No line to read", new Object[0]);
        }
        if (this.lineStart == this.limit && this.endOfStream) {
            return null;
        }
        T retVal = this.makeObject(this.buffer.array(), this.lineStart, lineEnd - this.lineStart);
        if (this.position < this.limit) {
            ++this.position;
        }
        this.lineStart = this.position;
        return retVal;
    }

    protected abstract T makeObject(byte[] var1, int var2, int var3);

    private void setBuffer(byte[] buffer) {
        this.buffer = ByteBuffer.wrap(buffer).order(ByteOrder.BIG_ENDIAN);
    }

    private static int firstOccurrence(long n, long pattern) {
        long xored = n ^ pattern;
        long zeroTest = xored - 0x101010101010101L & (xored ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L;
        return Long.numberOfLeadingZeros(zeroTest) >>> 3;
    }

    private static long firstOccurrencePattern(byte b) {
        return Longs.fromBytes((byte)b, (byte)b, (byte)b, (byte)b, (byte)b, (byte)b, (byte)b, (byte)b);
    }

    public static class Bytes
    extends FastLineIterator<byte[]> {
        public Bytes(InputStream source) {
            super(source);
        }

        @Override
        protected byte[] makeObject(byte[] bytes, int offset, int length) {
            byte[] retVal = new byte[length];
            System.arraycopy(bytes, offset, retVal, 0, length);
            return retVal;
        }
    }

    public static class Strings
    extends FastLineIterator<String> {
        public Strings(InputStream source) {
            super(source);
        }

        @Override
        protected String makeObject(byte[] bytes, int offset, int length) {
            return StringUtils.fromUtf8(bytes, offset, length);
        }
    }
}

