/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.query.LeafDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.RestrictedSegment;
import org.apache.druid.segment.SegmentMapFunction;

@JsonTypeName(value="restrictedInputNumber")
public class RestrictedInputNumberDataSource
extends LeafDataSource {
    private final int inputNumber;
    private final Policy policy;

    @JsonCreator
    public RestrictedInputNumberDataSource(@JsonProperty(value="inputNumber") int inputNumber, @JsonProperty(value="policy") Policy policy) {
        this.inputNumber = inputNumber;
        this.policy = (Policy)Preconditions.checkNotNull((Object)policy, (Object)"Policy can't be null");
    }

    @JsonProperty
    public int getInputNumber() {
        return this.inputNumber;
    }

    @JsonProperty
    public Policy getPolicy() {
        return this.policy;
    }

    public Set<String> getTableNames() {
        return Collections.emptySet();
    }

    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    public boolean isGlobal() {
        return false;
    }

    public boolean isProcessable() {
        return true;
    }

    public SegmentMapFunction createSegmentMapFunction(Query query) {
        return SegmentMapFunction.IDENTITY.thenMap(segment -> new RestrictedSegment(segment, this.policy));
    }

    public byte[] getCacheKey() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RestrictedInputNumberDataSource that = (RestrictedInputNumberDataSource)((Object)o);
        return this.inputNumber == that.inputNumber && this.policy.equals(that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.inputNumber, this.policy);
    }

    public String toString() {
        return "RestrictedInputNumberDataSource{inputNumber=" + this.inputNumber + ", policy=" + this.policy + "}";
    }
}

