/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyRowsInAWindow")
public class TooManyRowsInAWindowFault
extends BaseMSQFault {
    static final String CODE = "TooManyRowsInAWindow";
    private final int numRows;
    private final int maxRows;

    @JsonCreator
    public TooManyRowsInAWindowFault(@JsonProperty(value="numRows") int numRows, @JsonProperty(value="maxRows") int maxRows) {
        super(CODE, "Too many rows in a window (requested = %d, max = %d).  Try creating a window with a higher cardinality column or change the query shape. Or you can change the max using query context param %s . Use it carefully as a higher value can lead to OutOfMemory errors. ", numRows, maxRows, "maxRowsMaterializedInWindow");
        this.numRows = numRows;
        this.maxRows = maxRows;
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyRowsInAWindowFault that = (TooManyRowsInAWindowFault)o;
        return this.numRows == that.numRows && this.maxRows == that.maxRows;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numRows, this.maxRows);
    }
}

