/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimSchedulingStatus;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimSchedulingStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2ResourceClaimSchedulingStatusFluentImpl<A extends V1alpha2ResourceClaimSchedulingStatusFluent<A>>
extends BaseFluent<A>
implements V1alpha2ResourceClaimSchedulingStatusFluent<A> {
    private String name;
    private List<String> unsuitableNodes;

    public V1alpha2ResourceClaimSchedulingStatusFluentImpl() {
    }

    public V1alpha2ResourceClaimSchedulingStatusFluentImpl(V1alpha2ResourceClaimSchedulingStatus instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withUnsuitableNodes(instance.getUnsuitableNodes());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUnsuitableNodes(String ... items) {
        for (String item : items) {
            if (this.unsuitableNodes == null) continue;
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUnsuitableNodes(Collection<String> items) {
        for (String item : items) {
            if (this.unsuitableNodes == null) continue;
            this.unsuitableNodes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    @Override
    public String getUnsuitableNode(int index) {
        return this.unsuitableNodes.get(index);
    }

    @Override
    public String getFirstUnsuitableNode() {
        return this.unsuitableNodes.get(0);
    }

    @Override
    public String getLastUnsuitableNode() {
        return this.unsuitableNodes.get(this.unsuitableNodes.size() - 1);
    }

    @Override
    public String getMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUnsuitableNodes(List<String> unsuitableNodes) {
        if (unsuitableNodes != null) {
            this.unsuitableNodes = new ArrayList<String>();
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        } else {
            this.unsuitableNodes = null;
        }
        return (A)this;
    }

    @Override
    public A withUnsuitableNodes(String ... unsuitableNodes) {
        if (this.unsuitableNodes != null) {
            this.unsuitableNodes.clear();
            this._visitables.remove("unsuitableNodes");
        }
        if (unsuitableNodes != null) {
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUnsuitableNodes() {
        return this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClaimSchedulingStatusFluentImpl that = (V1alpha2ResourceClaimSchedulingStatusFluentImpl)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.unsuitableNodes, that.unsuitableNodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty()) {
            sb.append("unsuitableNodes:");
            sb.append(this.unsuitableNodes);
        }
        sb.append("}");
        return sb.toString();
    }
}

