/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.command;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.AbstractCommandParser;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;

public class SingleCommandParser<T>
extends AbstractCommandParser<T> {
    public ParseResult<T> parseWithResult(ParserMetadata<T> parserConfig, CommandMetadata commandMetadata, Iterable<GlobalRestriction> restrictions, Iterable<String> args) {
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        ParseState<T> state = this.tryParse(parserConfig, commandMetadata, args);
        this.validate(state, IteratorUtils.toList(restrictions.iterator()));
        return state.getParserConfiguration().getErrorHandler().finished(state);
    }

    public T parse(ParserMetadata<T> parserConfig, CommandMetadata commandMetadata, Iterable<GlobalRestriction> restrictions, Iterable<String> args) {
        ParseResult<T> result = this.parseWithResult(parserConfig, commandMetadata, restrictions, args);
        return result.getCommand();
    }

    protected void validate(ParseState<T> state, List<GlobalRestriction> restrictions) {
        for (GlobalRestriction restriction : restrictions) {
            if (restriction == null) continue;
            try {
                restriction.validate(state);
            }
            catch (ParseException e) {
                state.getParserConfiguration().getErrorHandler().handleError(e);
            }
        }
        CommandMetadata command = state.getCommand();
        if (command != null) {
            ArgumentsMetadata arguments = command.getArguments();
            if (arguments != null) {
                for (ArgumentsRestriction restriction : arguments.getRestrictions()) {
                    if (restriction == null) continue;
                    try {
                        restriction.finalValidate(state, arguments);
                    }
                    catch (ParseException e) {
                        state.getParserConfiguration().getErrorHandler().handleError(e);
                    }
                }
            }
            for (OptionMetadata option : command.getAllOptions()) {
                if (option == null) continue;
                for (OptionRestriction restriction : option.getRestrictions()) {
                    if (restriction == null) continue;
                    try {
                        restriction.finalValidate(state, option);
                    }
                    catch (ParseException e) {
                        state.getParserConfiguration().getErrorHandler().handleError(e);
                    }
                }
            }
        }
    }
}

