/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.events.ValueAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueModifiedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueMultiModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ValueRenamedEvent;
import org.apache.directory.studio.ldapbrowser.core.jobs.UpdateEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorConfiguration;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorInput;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorNavigationLocation;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorUniversalListener;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorWidget;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class SearchResultEditor
extends EditorPart
implements INavigationLocationProvider,
IReusableEditor,
IShowEditorInput,
IPropertyChangeListener {
    private SearchResultEditorConfiguration configuration;
    private SearchResultEditorActionGroup actionGroup;
    private SearchResultEditorWidget mainWidget;
    private SearchResultEditorUniversalListener universalListener;
    protected EntryUpdateListener entryUpdateListener = new EntryUpdateListener(){

        public void entryUpdated(EntryModificationEvent event) {
            if (SearchResultEditor.this.mainWidget.getViewer() == null || SearchResultEditor.this.mainWidget.getViewer().getInput() == null) {
                return;
            }
            IEntry modifiedEntry = event.getModifiedEntry();
            IEntry originalEntry = modifiedEntry.getBrowserConnection().getEntryFromCache(modifiedEntry.getDn());
            ISearchResult referenceCopy = SearchResultEditor.this.configuration.getCursor(SearchResultEditor.this.mainWidget.getViewer()).getSelectedReferenceCopy();
            ISearchResult workingCopy = SearchResultEditor.this.configuration.getCursor(SearchResultEditor.this.mainWidget.getViewer()).getSelectedSearchResult();
            if (workingCopy != null && workingCopy.getEntry() == modifiedEntry) {
                if (!(event instanceof ValueAddedEvent || event instanceof ValueDeletedEvent || event instanceof ValueModifiedEvent || event instanceof ValueRenamedEvent || event instanceof ValueMultiModificationEvent)) {
                    return;
                }
                IAttribute[] iAttributeArray = modifiedEntry.getAttributes();
                int n = iAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAttribute attribute = iAttributeArray[n2];
                    IValue[] iValueArray = attribute.getValues();
                    int n3 = iValueArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IValue value = iValueArray[n4];
                        if (value.isEmpty()) {
                            return;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                LdifFile diff = Utils.computeDiff((IEntry)referenceCopy.getEntry(), (IEntry)modifiedEntry);
                if (diff != null) {
                    UpdateEntryRunnable runnable = new UpdateEntryRunnable(originalEntry, diff.toFormattedString(LdifFormatParameters.DEFAULT));
                    RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
                }
                SearchResultEditor.this.configuration.getCursor(SearchResultEditor.this.mainWidget.getViewer()).resetCopies();
            }
        }
    };

    public static String getId() {
        return BrowserUIConstants.EDITOR_SEARCH_RESULT;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof SearchResultEditorInput && this.universalListener != null) {
            this.setPartName(input.getName());
            SearchResultEditorInput srei = (SearchResultEditorInput)input;
            this.setSearchResultEditorWidgetInput(srei);
        }
    }

    public void showEditorInput(IEditorInput input) {
        if (input instanceof SearchResultEditorInput) {
            if (this.getEditorInput() != null && this.getEditorInput().equals(input)) {
                return;
            }
            this.setInput(input);
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
            this.firePropertyChange(1342730831);
        }
    }

    private void setSearchResultEditorWidgetInput(SearchResultEditorInput srei) {
        ISearch search = srei.getSearch();
        this.universalListener.setInput(search);
    }

    public void refresh() {
        if (this.universalListener != null) {
            this.universalListener.refreshInput();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this.entryUpdateListener, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_search_result_editor");
        this.configuration = new SearchResultEditorConfiguration((IWorkbenchPart)this);
        this.mainWidget = new SearchResultEditorWidget(this.configuration);
        this.mainWidget.createWidget(composite);
        this.actionGroup = new SearchResultEditorActionGroup(this);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.enableGlobalActionHandlers(this.getEditorSite().getActionBars());
        this.actionGroup.fillContextMenu(this.configuration.getContextMenuManager(this.mainWidget.getViewer()));
        this.universalListener = new SearchResultEditorUniversalListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.configuration.getCursor(this.mainWidget.getViewer()));
        this.setInput(this.getEditorInput());
        BrowserUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setFocus() {
        this.mainWidget.setFocus();
    }

    public void dispose() {
        if (this.configuration != null) {
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this.entryUpdateListener);
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.configuration.dispose();
            this.configuration = null;
            this.getSite().setSelectionProvider(null);
            BrowserUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new SearchResultEditorNavigationLocation(this);
    }

    public Object getAdapter(Class required) {
        if (IShowInTargetList.class.equals((Object)required)) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{BrowserView.getId()};
                }
            };
        }
        if (IShowInSource.class.equals((Object)required)) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ISelection selection = SearchResultEditor.this.getConfiguration().getCursor(SearchResultEditor.this.getMainWidget().getViewer()).getSelection();
                    return new ShowInContext(SearchResultEditor.this.getMainWidget().getViewer().getInput(), selection);
                }
            };
        }
        return super.getAdapter(required);
    }

    public SearchResultEditorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public SearchResultEditorConfiguration getConfiguration() {
        return this.configuration;
    }

    public SearchResultEditorWidget getMainWidget() {
        return this.mainWidget;
    }

    public SearchResultEditorUniversalListener getUniversalListener() {
        return this.universalListener;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.refresh();
    }
}

