/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import java.util.Collection;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.UsageEnum;
import org.apache.directory.studio.common.ui.CommonUIPlugin;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeTypeDescriptionDetailsPage
extends SchemaDetailsPage {
    private Section mainSection;
    private Text numericOidText;
    private Text namesText;
    private Text descText;
    private Text usageText;
    private Section flagSection;
    private Label singleValuedLabel;
    private Label isObsoleteLabel;
    private Label collectiveLabel;
    private Label noUserModificationLabel;
    private Section syntaxSection;
    private Text syntaxDescText;
    private Text lengthText;
    private Hyperlink syntaxLink;
    private Section matchingRulesSection;
    private Hyperlink equalityLink;
    private Hyperlink substringLink;
    private Hyperlink orderingLink;
    private Section otherMatchSection;
    private Section usedAsMustSection;
    private Section usedAsMaySection;
    private Section supertypeSection;
    private Section subtypesSection;

    public AttributeTypeDescriptionDetailsPage(SchemaPage schemaPage, FormToolkit toolkit) {
        super(schemaPage, toolkit);
    }

    @Override
    protected void createContents(final ScrolledForm detailForm) {
        this.detailForm = detailForm;
        detailForm.getBody().setLayout((Layout)new GridLayout());
        this.mainSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.mainSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Details"));
        this.mainSection.marginWidth = 0;
        this.mainSection.marginHeight = 0;
        this.mainSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.mainSection);
        this.flagSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.flagSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Flags"));
        this.flagSection.marginWidth = 0;
        this.flagSection.marginHeight = 0;
        this.flagSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.flagSection);
        Composite flagClient = this.toolkit.createComposite((Composite)this.flagSection, 64);
        GridLayout flagLayout = new GridLayout();
        flagLayout.numColumns = 4;
        flagLayout.marginWidth = 0;
        flagLayout.marginHeight = 0;
        flagClient.setLayout((Layout)flagLayout);
        this.flagSection.setClient((Control)flagClient);
        this.singleValuedLabel = this.toolkit.createLabel(flagClient, Messages.getString("AttributeTypeDescriptionDetailsPage.SingleValued"), 32);
        this.singleValuedLabel.setLayoutData((Object)new GridData(768));
        this.noUserModificationLabel = this.toolkit.createLabel(flagClient, Messages.getString("AttributeTypeDescriptionDetailsPage.ReadOnly"), 32);
        this.noUserModificationLabel.setLayoutData((Object)new GridData(768));
        this.collectiveLabel = this.toolkit.createLabel(flagClient, Messages.getString("AttributeTypeDescriptionDetailsPage.Collective"), 32);
        this.collectiveLabel.setLayoutData((Object)new GridData(768));
        this.isObsoleteLabel = this.toolkit.createLabel(flagClient, Messages.getString("AttributeTypeDescriptionDetailsPage.Obsolete"), 32);
        this.isObsoleteLabel.setLayoutData((Object)new GridData(768));
        this.syntaxSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.syntaxSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Syntax"));
        this.syntaxSection.marginWidth = 0;
        this.syntaxSection.marginHeight = 0;
        this.syntaxSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.syntaxSection);
        Composite syntaxClient = this.toolkit.createComposite((Composite)this.syntaxSection, 64);
        GridLayout syntaxLayout = new GridLayout();
        syntaxLayout.numColumns = 2;
        syntaxLayout.marginWidth = 0;
        syntaxLayout.marginHeight = 0;
        syntaxClient.setLayout((Layout)syntaxLayout);
        this.syntaxSection.setClient((Control)syntaxClient);
        this.toolkit.createLabel(syntaxClient, Messages.getString("AttributeTypeDescriptionDetailsPage.SyntaxOID"), 0);
        this.syntaxLink = this.toolkit.createHyperlink(syntaxClient, "", 64);
        this.syntaxLink.setLayoutData((Object)new GridData(768));
        this.syntaxLink.addHyperlinkListener((IHyperlinkListener)this);
        this.toolkit.createLabel(syntaxClient, Messages.getString("AttributeTypeDescriptionDetailsPage.SyntaxDescription"), 0);
        this.syntaxDescText = this.toolkit.createText(syntaxClient, "", 0);
        this.syntaxDescText.setLayoutData((Object)new GridData(768));
        this.syntaxDescText.setEditable(false);
        this.toolkit.createLabel(syntaxClient, Messages.getString("AttributeTypeDescriptionDetailsPage.Length"), 0);
        this.lengthText = this.toolkit.createText(syntaxClient, "", 0);
        this.lengthText.setLayoutData((Object)new GridData(768));
        this.lengthText.setEditable(false);
        this.matchingRulesSection = this.toolkit.createSection(detailForm.getBody(), 0);
        this.matchingRulesSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.MatchingRules"));
        this.matchingRulesSection.marginWidth = 0;
        this.matchingRulesSection.marginHeight = 0;
        this.matchingRulesSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.matchingRulesSection);
        Composite matchClient = this.toolkit.createComposite((Composite)this.matchingRulesSection, 64);
        GridLayout matchLayout = new GridLayout();
        matchLayout.numColumns = 2;
        matchLayout.marginWidth = 0;
        matchLayout.marginHeight = 0;
        matchClient.setLayout((Layout)matchLayout);
        this.matchingRulesSection.setClient((Control)matchClient);
        this.toolkit.createLabel(matchClient, Messages.getString("AttributeTypeDescriptionDetailsPage.EqualityMatch"), 0);
        this.equalityLink = this.toolkit.createHyperlink(matchClient, "", 64);
        this.equalityLink.setLayoutData((Object)new GridData(768));
        this.equalityLink.addHyperlinkListener((IHyperlinkListener)this);
        this.toolkit.createLabel(matchClient, Messages.getString("AttributeTypeDescriptionDetailsPage.SubstringMatch"), 0);
        this.substringLink = this.toolkit.createHyperlink(matchClient, "", 64);
        this.substringLink.setLayoutData((Object)new GridData(768));
        this.substringLink.addHyperlinkListener((IHyperlinkListener)this);
        this.toolkit.createLabel(matchClient, Messages.getString("AttributeTypeDescriptionDetailsPage.OrderingMatch"), 0);
        this.orderingLink = this.toolkit.createHyperlink(matchClient, "", 64);
        this.orderingLink.setLayoutData((Object)new GridData(768));
        this.orderingLink.addHyperlinkListener((IHyperlinkListener)this);
        this.otherMatchSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.otherMatchSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.OtherMatchingRules"));
        this.otherMatchSection.marginWidth = 0;
        this.otherMatchSection.marginHeight = 0;
        this.otherMatchSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.otherMatchSection);
        this.otherMatchSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.usedAsMustSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.usedAsMustSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMust"));
        this.usedAsMustSection.marginWidth = 0;
        this.usedAsMustSection.marginHeight = 0;
        this.usedAsMustSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.usedAsMustSection);
        this.usedAsMustSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.usedAsMaySection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.usedAsMaySection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMay"));
        this.usedAsMaySection.marginWidth = 0;
        this.usedAsMaySection.marginHeight = 0;
        this.usedAsMaySection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.usedAsMaySection);
        this.usedAsMaySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.supertypeSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.supertypeSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Supertype"));
        this.supertypeSection.marginWidth = 0;
        this.supertypeSection.marginHeight = 0;
        this.supertypeSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.supertypeSection);
        this.supertypeSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.subtypesSection = this.toolkit.createSection(detailForm.getBody(), 2);
        this.subtypesSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Subtypes"));
        this.subtypesSection.marginWidth = 0;
        this.subtypesSection.marginHeight = 0;
        this.subtypesSection.setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.subtypesSection);
        this.subtypesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                detailForm.reflow(true);
            }
        });
        this.createRawSection();
    }

    @Override
    public void setInput(Object input) {
        AttributeType atd = null;
        if (input instanceof AttributeType) {
            atd = (AttributeType)input;
        }
        this.createMainContent(atd);
        if (atd != null && atd.isSingleValued()) {
            this.singleValuedLabel.setForeground(this.getColor("defaultColor"));
        } else {
            this.singleValuedLabel.setForeground(this.getColor("disabledColor"));
        }
        if (atd != null && atd.isObsolete()) {
            this.isObsoleteLabel.setForeground(this.getColor("defaultColor"));
        } else {
            this.isObsoleteLabel.setForeground(this.getColor("disabledColor"));
        }
        if (atd != null && atd.isCollective()) {
            this.collectiveLabel.setForeground(this.getColor("defaultColor"));
        } else {
            this.collectiveLabel.setForeground(this.getColor("disabledColor"));
        }
        if (atd != null && !atd.isUserModifiable()) {
            this.noUserModificationLabel.setForeground(this.getColor("defaultColor"));
        } else {
            this.noUserModificationLabel.setForeground(this.getColor("disabledColor"));
        }
        this.flagSection.layout();
        String lsdOid = null;
        LdapSyntax lsd = null;
        long lsdLength = 0L;
        if (atd != null) {
            lsdOid = SchemaUtils.getSyntaxNumericOidTransitive((AttributeType)atd, (Schema)this.getSchema());
            if (lsdOid != null && this.getSchema().hasLdapSyntaxDescription(lsdOid)) {
                lsd = this.getSchema().getLdapSyntaxDescription(lsdOid);
            }
            lsdLength = SchemaUtils.getSyntaxLengthTransitive((AttributeType)atd, (Schema)this.getSchema());
        }
        this.syntaxLink.setText(this.getNonNullString(lsd != null ? lsd.getOid() : lsdOid));
        this.syntaxLink.setHref(lsd);
        this.syntaxLink.setUnderlined(lsd != null);
        this.syntaxLink.setEnabled(lsd != null);
        this.syntaxDescText.setText(this.getNonNullString(lsd != null ? lsd.getDescription() : null));
        this.lengthText.setText(this.getNonNullString(lsdLength > 0L ? Long.toString(lsdLength) : null));
        this.syntaxSection.layout();
        String emrOid = null;
        MatchingRule emr = null;
        if (atd != null && (emrOid = SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive((AttributeType)atd, (Schema)this.getSchema())) != null && this.getSchema().hasMatchingRuleDescription(emrOid)) {
            emr = this.getSchema().getMatchingRuleDescription(emrOid);
        }
        this.equalityLink.setText(this.getNonNullString(emr != null ? SchemaUtils.toString(emr) : emrOid));
        this.equalityLink.setHref(emr);
        this.equalityLink.setUnderlined(emr != null);
        this.equalityLink.setEnabled(emr != null);
        String smrOid = null;
        MatchingRule smr = null;
        if (atd != null && (smrOid = SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive((AttributeType)atd, (Schema)this.getSchema())) != null && this.getSchema().hasMatchingRuleDescription(smrOid)) {
            smr = this.getSchema().getMatchingRuleDescription(smrOid);
        }
        this.substringLink.setText(this.getNonNullString(smr != null ? SchemaUtils.toString(smr) : smrOid));
        this.substringLink.setHref(smr);
        this.substringLink.setUnderlined(smr != null);
        this.substringLink.setEnabled(smr != null);
        String omrOid = null;
        MatchingRule omr = null;
        if (atd != null && (omrOid = SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive((AttributeType)atd, (Schema)this.getSchema())) != null && this.getSchema().hasMatchingRuleDescription(omrOid)) {
            omr = this.getSchema().getMatchingRuleDescription(omrOid);
        }
        this.orderingLink.setText(this.getNonNullString(omr != null ? SchemaUtils.toString(omr) : omrOid));
        this.orderingLink.setHref(omr);
        this.orderingLink.setUnderlined(omr != null);
        this.orderingLink.setEnabled(omr != null);
        this.matchingRulesSection.layout();
        this.createOtherMatchContent(atd);
        this.createUsedAsMustContent(atd);
        this.createUsedAsMayContent(atd);
        this.createSupertypeContent(atd);
        this.createSubtypesContent(atd);
        this.createRawContents((AbstractSchemaObject)atd);
        this.detailForm.reflow(true);
    }

    private Color getColor(String color) {
        return CommonUIPlugin.getDefault().getColor(color);
    }

    private void createMainContent(AttributeType atd) {
        if (this.mainSection.getClient() != null) {
            this.mainSection.getClient().dispose();
        }
        Composite mainClient = this.toolkit.createComposite((Composite)this.mainSection, 64);
        GridLayout mainLayout = new GridLayout(2, false);
        mainClient.setLayout((Layout)mainLayout);
        this.mainSection.setClient((Control)mainClient);
        if (atd != null) {
            this.toolkit.createLabel(mainClient, Messages.getString("AttributeTypeDescriptionDetailsPage.NumericOID"), 0);
            this.numericOidText = this.toolkit.createText(mainClient, this.getNonNullString(atd.getOid()), 0);
            this.numericOidText.setLayoutData((Object)new GridData(768));
            this.numericOidText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("AttributeTypeDescriptionDetailsPage.AttributeNames"), 0);
            this.namesText = this.toolkit.createText(mainClient, this.getNonNullString(SchemaUtils.toString((AbstractSchemaObject)atd)), 0);
            this.namesText.setLayoutData((Object)new GridData(768));
            this.namesText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("AttributeTypeDescriptionDetailsPage.Description"), 64);
            this.descText = this.toolkit.createText(mainClient, this.getNonNullString(atd.getDescription()), 66);
            GridData gd = new GridData(768);
            gd.widthHint = this.detailForm.getForm().getSize().x - 100 - 60;
            this.descText.setLayoutData((Object)gd);
            this.descText.setEditable(false);
            this.toolkit.createLabel(mainClient, Messages.getString("AttributeTypeDescriptionDetailsPage.Usage"), 0);
            this.usageText = this.toolkit.createText(mainClient, this.getNonNullString(UsageEnum.render((UsageEnum)atd.getUsage())), 0);
            this.usageText.setLayoutData((Object)new GridData(512));
            this.usageText.setEditable(false);
        }
        this.mainSection.layout();
    }

    private void createOtherMatchContent(AttributeType atd) {
        if (this.otherMatchSection.getClient() != null) {
            this.otherMatchSection.getClient().dispose();
        }
        Composite otherMatchClient = this.toolkit.createComposite((Composite)this.otherMatchSection, 64);
        otherMatchClient.setLayout((Layout)new GridLayout());
        this.otherMatchSection.setClient((Control)otherMatchClient);
        if (atd != null) {
            Collection otherMrdNames = SchemaUtils.getOtherMatchingRuleDescriptionNames((AttributeType)atd, (Schema)this.getSchema());
            if (otherMrdNames != null && otherMrdNames.size() > 0) {
                this.otherMatchSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.OtherMatchingRulesCount"), (Object[])new Object[]{otherMrdNames.size()}));
                for (String mrdName : otherMrdNames) {
                    if (this.getSchema().hasMatchingRuleDescription(mrdName)) {
                        MatchingRule mrd = this.getSchema().getMatchingRuleDescription(mrdName);
                        Hyperlink otherMatchLink = this.toolkit.createHyperlink(otherMatchClient, SchemaUtils.toString((AbstractSchemaObject)mrd), 64);
                        otherMatchLink.setHref((Object)mrd);
                        otherMatchLink.setLayoutData((Object)new GridData(768));
                        otherMatchLink.setUnderlined(true);
                        otherMatchLink.setEnabled(true);
                        otherMatchLink.addHyperlinkListener((IHyperlinkListener)this);
                        continue;
                    }
                    Hyperlink otherMatchLink = this.toolkit.createHyperlink(otherMatchClient, mrdName, 64);
                    otherMatchLink.setHref(null);
                    otherMatchLink.setUnderlined(false);
                    otherMatchLink.setEnabled(false);
                }
            } else {
                this.otherMatchSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.OtherMatchingRulesCount"), (Object[])new Object[]{0}));
                Text otherText = this.toolkit.createText(otherMatchClient, this.getNonNullString(null), 0);
                otherText.setLayoutData((Object)new GridData(768));
                otherText.setEditable(false);
            }
        } else {
            this.otherMatchSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.OtherMatchingRules"));
        }
        this.otherMatchSection.layout();
    }

    private void createSupertypeContent(AttributeType atd) {
        if (this.supertypeSection.getClient() != null) {
            this.supertypeSection.getClient().dispose();
        }
        Composite superClient = this.toolkit.createComposite((Composite)this.supertypeSection, 64);
        superClient.setLayout((Layout)new GridLayout());
        this.supertypeSection.setClient((Control)superClient);
        if (atd != null) {
            String superType = atd.getSuperiorOid();
            if (superType != null) {
                this.supertypeSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.SupertypeCount"), (Object[])new Object[]{1}));
                if (this.getSchema().hasAttributeTypeDescription(superType)) {
                    AttributeType supAtd = this.getSchema().getAttributeTypeDescription(superType);
                    Hyperlink superLink = this.toolkit.createHyperlink(superClient, SchemaUtils.toString((AbstractSchemaObject)supAtd), 64);
                    superLink.setHref((Object)supAtd);
                    superLink.setLayoutData((Object)new GridData(768));
                    superLink.setUnderlined(true);
                    superLink.setEnabled(true);
                    superLink.addHyperlinkListener((IHyperlinkListener)this);
                } else {
                    Hyperlink superLink = this.toolkit.createHyperlink(superClient, superType, 64);
                    superLink.setHref(null);
                    superLink.setUnderlined(false);
                    superLink.setEnabled(false);
                }
            } else {
                this.supertypeSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.SupertypeCount"), (Object[])new Object[]{0}));
                Text supText = this.toolkit.createText(superClient, this.getNonNullString(null), 0);
                supText.setLayoutData((Object)new GridData(768));
                supText.setEditable(false);
            }
        } else {
            this.supertypeSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Supertype"));
        }
        this.supertypeSection.layout();
    }

    private void createSubtypesContent(AttributeType atd) {
        if (this.subtypesSection.getClient() != null) {
            this.subtypesSection.getClient().dispose();
        }
        Composite subClient = this.toolkit.createComposite((Composite)this.subtypesSection, 64);
        subClient.setLayout((Layout)new GridLayout());
        this.subtypesSection.setClient((Control)subClient);
        if (atd != null) {
            Collection derivedAtds = SchemaUtils.getDerivedAttributeTypeDescriptions((AttributeType)atd, (Schema)this.getSchema());
            if (derivedAtds != null && derivedAtds.size() > 0) {
                this.subtypesSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.SubtypesCount"), (Object[])new Object[]{derivedAtds.size()}));
                for (AttributeType derivedAtd : derivedAtds) {
                    Hyperlink subAttributeTypeLink = this.toolkit.createHyperlink(subClient, SchemaUtils.toString((AbstractSchemaObject)derivedAtd), 64);
                    subAttributeTypeLink.setHref((Object)derivedAtd);
                    subAttributeTypeLink.setLayoutData((Object)new GridData(768));
                    subAttributeTypeLink.setUnderlined(true);
                    subAttributeTypeLink.setEnabled(true);
                    subAttributeTypeLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.subtypesSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.SubtypesCount"), (Object[])new Object[]{0}));
                Text subText = this.toolkit.createText(subClient, this.getNonNullString(null), 0);
                subText.setLayoutData((Object)new GridData(768));
                subText.setEditable(false);
            }
        } else {
            this.subtypesSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.Subtypes"));
        }
        this.subtypesSection.layout();
    }

    private void createUsedAsMustContent(AttributeType atd) {
        if (this.usedAsMustSection.getClient() != null) {
            this.usedAsMustSection.getClient().dispose();
        }
        Composite mustClient = this.toolkit.createComposite((Composite)this.usedAsMustSection, 64);
        mustClient.setLayout((Layout)new GridLayout());
        this.usedAsMustSection.setClient((Control)mustClient);
        if (atd != null) {
            Collection usedAsMusts = SchemaUtils.getUsedAsMust((AttributeType)atd, (Schema)this.getSchema());
            if (usedAsMusts != null && usedAsMusts.size() > 0) {
                this.usedAsMustSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMustCount"), (Object[])new Object[]{usedAsMusts.size()}));
                for (ObjectClass ocd : usedAsMusts) {
                    Hyperlink usedAsMustLink = this.toolkit.createHyperlink(mustClient, SchemaUtils.toString((AbstractSchemaObject)ocd), 64);
                    usedAsMustLink.setHref((Object)ocd);
                    usedAsMustLink.setLayoutData((Object)new GridData(768));
                    usedAsMustLink.setUnderlined(true);
                    usedAsMustLink.setEnabled(true);
                    usedAsMustLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.usedAsMustSection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMustCount"), (Object[])new Object[]{0}));
                Text mustText = this.toolkit.createText(mustClient, this.getNonNullString(null), 0);
                mustText.setLayoutData((Object)new GridData(768));
                mustText.setEditable(false);
            }
        } else {
            this.usedAsMustSection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMust"));
        }
        this.usedAsMustSection.layout();
    }

    private void createUsedAsMayContent(AttributeType atd) {
        if (this.usedAsMaySection.getClient() != null) {
            this.usedAsMaySection.getClient().dispose();
        }
        Composite mayClient = this.toolkit.createComposite((Composite)this.usedAsMaySection, 64);
        mayClient.setLayout((Layout)new GridLayout());
        this.usedAsMaySection.setClient((Control)mayClient);
        if (atd != null) {
            Collection usedAsMays = SchemaUtils.getUsedAsMay((AttributeType)atd, (Schema)this.getSchema());
            if (usedAsMays != null && usedAsMays.size() > 0) {
                this.usedAsMaySection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMayCount"), (Object[])new Object[]{usedAsMays.size()}));
                for (ObjectClass ocd : usedAsMays) {
                    Hyperlink usedAsMayLink = this.toolkit.createHyperlink(mayClient, SchemaUtils.toString((AbstractSchemaObject)ocd), 64);
                    usedAsMayLink.setHref((Object)ocd);
                    usedAsMayLink.setLayoutData((Object)new GridData(768));
                    usedAsMayLink.setUnderlined(true);
                    usedAsMayLink.setEnabled(true);
                    usedAsMayLink.addHyperlinkListener((IHyperlinkListener)this);
                }
            } else {
                this.usedAsMaySection.setText(NLS.bind((String)Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMayCount"), (Object[])new Object[]{0}));
                Text mayText = this.toolkit.createText(mayClient, this.getNonNullString(null), 0);
                mayText.setLayoutData((Object)new GridData(768));
                mayText.setEditable(false);
            }
        } else {
            this.usedAsMaySection.setText(Messages.getString("AttributeTypeDescriptionDetailsPage.UsedAsMay"));
        }
        this.usedAsMaySection.layout();
    }
}

