/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;

public class ReloadSchemaRunnable
implements StudioConnectionBulkRunnableWithProgress {
    private IBrowserConnection browserConnection;

    public ReloadSchemaRunnable(IBrowserConnection browserConnection) {
        this.browserConnection = browserConnection;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__reload_schemas_name_1;
    }

    public Object[] getLockedObjects() {
        return new IBrowserConnection[]{this.browserConnection};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__reload_schemas_error_1;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", 3);
        monitor.reportProgress(" ");
        monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__reload_schemas_task, (Object[])new String[]{this.browserConnection.getConnection().getName()}));
        monitor.worked(1);
        monitor.reportProgress(BrowserCoreMessages.model__loading_schema);
        ReloadSchemaRunnable.reloadSchema(true, this.browserConnection, monitor);
        monitor.worked(1);
    }

    public void runNotification(StudioProgressMonitor monitor) {
        BrowserConnectionUpdateEvent browserConnectionUpdateEvent = new BrowserConnectionUpdateEvent(this.browserConnection, BrowserConnectionUpdateEvent.Detail.SCHEMA_UPDATED);
        EventRegistry.fireBrowserConnectionUpdated(browserConnectionUpdateEvent, this);
    }

    public static void reloadSchema(boolean forceReload, IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        boolean mustReload;
        Dn schemaLocation = ReloadSchemaRunnable.getSchemaLocation(browserConnection, monitor);
        if (schemaLocation == null) {
            monitor.reportError(BrowserCoreMessages.model__missing_schema_location);
            return;
        }
        Schema schema = browserConnection.getSchema();
        boolean bl = mustReload = forceReload || schema == Schema.DEFAULT_SCHEMA || ReloadSchemaRunnable.mustReload(schemaLocation, browserConnection, monitor);
        if (mustReload) {
            browserConnection.setSchema(Schema.DEFAULT_SCHEMA);
            try {
                SearchParameter sp = new SearchParameter();
                sp.setSearchBase(schemaLocation);
                sp.setFilter("(objectClass=subschema)");
                sp.setScope(SearchScope.OBJECT);
                sp.setReturningAttributes(new String[]{"objectClasses", "attributeTypes", "ldapSyntaxes", "matchingRules", "matchingRuleUse", "createTimestamp", "modifyTimestamp"});
                LdifEnumeration le = ExportLdifRunnable.search(browserConnection, sp, monitor);
                if (le.hasNext()) {
                    LdifContentRecord schemaRecord = (LdifContentRecord)le.next();
                    schema = new Schema();
                    schema.loadFromRecord(schemaRecord);
                    browserConnection.setSchema(schema);
                } else {
                    monitor.reportError(BrowserCoreMessages.model__no_schema_information);
                }
            }
            catch (Exception e) {
                monitor.reportError(BrowserCoreMessages.model__error_loading_schema, e);
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean mustReload(Dn schemaLocation, IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        Schema schema = browserConnection.getSchema();
        try {
            String schemaTimestamp;
            String cacheTimestamp;
            SearchParameter sp = new SearchParameter();
            sp.setSearchBase(schemaLocation);
            sp.setFilter("(objectClass=subschema)");
            sp.setScope(SearchScope.OBJECT);
            sp.setReturningAttributes(new String[]{"createTimestamp", "modifyTimestamp"});
            StudioSearchResultEnumeration enumeration = SearchRunnable.search(browserConnection, sp, monitor);
            do {
                if (enumeration == null) return false;
                if (!enumeration.hasMore()) {
                    return false;
                }
                String createTimestamp = null;
                String modifyTimestamp = null;
                Entry entry = enumeration.next().getEntry();
                if (entry.hasObjectClass(new String[]{"modifyTimestamp"})) {
                    modifyTimestamp = entry.get("modifyTimestamp").getString();
                }
                if (entry.hasObjectClass(new String[]{"createTimestamp"})) {
                    createTimestamp = entry.get("createTimestamp").getString();
                }
                schemaTimestamp = modifyTimestamp != null ? modifyTimestamp : createTimestamp;
            } while ((cacheTimestamp = schema.getModifyTimestamp() != null ? schema.getModifyTimestamp() : schema.getCreateTimestamp()) == null || schemaTimestamp == null || schemaTimestamp.compareTo(cacheTimestamp) <= 0);
            return true;
        }
        catch (Exception e) {
            monitor.reportError(BrowserCoreMessages.model__error_loading_schema, e);
            e.printStackTrace();
        }
        return false;
    }

    private static Dn getSchemaLocation(IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        try {
            SearchParameter sp = new SearchParameter();
            sp.setSearchBase(new Dn());
            sp.setScope(SearchScope.OBJECT);
            sp.setReturningAttributes(new String[]{"subschemaSubentry"});
            StudioSearchResultEnumeration enumeration = SearchRunnable.search(browserConnection, sp, monitor);
            while (enumeration != null && enumeration.hasMore()) {
                String value;
                Entry entry = enumeration.next().getEntry();
                if (!entry.containsAttribute(new String[]{"subschemaSubentry"}) || !Dn.isValid((String)(value = entry.get("subschemaSubentry").getString()))) continue;
                Dn dn = new Dn(new String[]{value});
                return dn;
            }
        }
        catch (Exception e) {
            monitor.reportError(BrowserCoreMessages.model__error_loading_schema, e);
            return null;
        }
        return null;
    }
}

