/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.i18n.I18n;

final class JavaLdapSupport {
    public static final String JOBJECT_ATTR = "javaObject";
    public static final String JCONTAINER_ATTR = "javaContainer";
    public static final String JSERIALIZEDOBJ_ATTR = "javaSerializedObject";
    public static final String JCLASSNAME_ATTR = "javaClassName";
    public static final String JCLASSNAMES_ATTR = "javaClassNames";
    public static final String JSERIALDATA_ATTR = "javaSerializedData";

    private JavaLdapSupport() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object deserialize(Entry serverEntry) throws NamingException {
        String className = null;
        try {
            className = serverEntry.get(JCLASSNAME_ATTR).getString();
        }
        catch (LdapInvalidAttributeValueException liave) {
            NamingException ne = new NamingException(I18n.err((I18n)I18n.ERR_479, (Object[])new Object[]{className, liave.getLocalizedMessage()}));
            ne.setRootCause(liave);
            throw ne;
        }
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(serverEntry.get(JSERIALDATA_ATTR).getBytes()));){
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            NamingException ne = new NamingException(I18n.err((I18n)I18n.ERR_479, (Object[])new Object[]{className, e.getLocalizedMessage()}));
            ne.setRootCause(e);
            throw ne;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] serialize(Object obj) throws LdapException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytesOut);){
            out.writeObject(obj);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new LdapException(I18n.err((I18n)I18n.ERR_481, (Object[])new Object[]{obj, e.getLocalizedMessage()}));
        }
    }

    static void serialize(Entry entry, Object obj, SchemaManager schemaManager) throws LdapException {
        entry.put("objectClass", new String[]{"top", JOBJECT_ATTR, JCONTAINER_ATTR, JSERIALIZEDOBJ_ATTR});
        entry.put(JCLASSNAME_ATTR, new String[]{obj.getClass().getName()});
        entry.put(JSERIALDATA_ATTR, (byte[][])new byte[][]{JavaLdapSupport.serialize(obj)});
        Class<?>[] classes = obj.getClass().getClasses();
        AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(JCLASSNAMES_ATTR);
        DefaultAttribute javaClassNames = new DefaultAttribute(attributeType, new String[]{JCLASSNAMES_ATTR});
        for (int ii = 0; ii < classes.length; ++ii) {
            javaClassNames.add(new String[]{classes[ii].getName()});
        }
        entry.put(new Attribute[]{javaClassNames});
    }
}

