/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.server.config.beans.AuthenticationInterceptorBean;
import org.apache.directory.server.config.beans.DirectoryServiceBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.PasswordPolicyBean;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPoliciesMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PasswordPoliciesPage
extends ServerConfigurationEditorPage {
    private static final String AUTHENTICATION_INTERCEPTOR_ID = "authenticationInterceptor";
    private static final String PASSWORD_POLICY_ID_DEFAULT = "default";
    public static final String ID = PasswordPoliciesPage.class.getName();
    private static final String TITLE = Messages.getString("PasswordPoliciesPage.PasswordPolicies");
    private PasswordPoliciesMasterDetailsBlock masterDetailsBlock;

    public PasswordPoliciesPage(ServerConfigurationEditor editor) {
        super(editor, ID, TITLE);
    }

    @Override
    protected void createFormContent(Composite parent, FormToolkit toolkit) {
        this.masterDetailsBlock = new PasswordPoliciesMasterDetailsBlock(this);
        this.masterDetailsBlock.createContent(this.getManagedForm());
    }

    @Override
    protected void refreshUI() {
        if (this.isInitialized()) {
            this.masterDetailsBlock.refreshUI();
        }
    }

    public static PasswordPolicyBean getPasswordPolicyBean(DirectoryServiceBean directoryServiceBean) {
        PasswordPolicyBean passwordPolicyBean = PasswordPoliciesPage.findPasswordPolicyBean(directoryServiceBean);
        if (passwordPolicyBean == null) {
            PasswordPoliciesPage.addPasswordPolicyBean(directoryServiceBean);
        }
        return passwordPolicyBean;
    }

    private static PasswordPolicyBean findPasswordPolicyBean(DirectoryServiceBean directoryServiceBean) {
        return PasswordPoliciesPage.getPasswordPolicyBean(PasswordPoliciesPage.getAuthenticationInterceptorBean(directoryServiceBean));
    }

    private static AuthenticationInterceptorBean getAuthenticationInterceptorBean(DirectoryServiceBean directoryServiceBean) {
        for (InterceptorBean interceptor : directoryServiceBean.getInterceptors()) {
            if (!AUTHENTICATION_INTERCEPTOR_ID.equalsIgnoreCase(interceptor.getInterceptorId()) || !(interceptor instanceof AuthenticationInterceptorBean)) continue;
            return (AuthenticationInterceptorBean)interceptor;
        }
        return null;
    }

    private static PasswordPolicyBean getPasswordPolicyBean(AuthenticationInterceptorBean authenticationInterceptor) {
        if (authenticationInterceptor != null) {
            for (PasswordPolicyBean passwordPolicy : authenticationInterceptor.getPasswordPolicies()) {
                if (!PASSWORD_POLICY_ID_DEFAULT.equalsIgnoreCase(passwordPolicy.getPwdId())) continue;
                return passwordPolicy;
            }
        }
        return null;
    }

    private static void addPasswordPolicyBean(DirectoryServiceBean directoryServiceBean) {
        AuthenticationInterceptorBean authenticationInterceptor = PasswordPoliciesPage.getAuthenticationInterceptorBean(directoryServiceBean);
        if (authenticationInterceptor != null) {
            PasswordPolicyBean passwordPolicy = new PasswordPolicyBean();
            passwordPolicy.setPwdId(PASSWORD_POLICY_ID_DEFAULT);
            passwordPolicy.setPwdAttribute("userPassword");
            passwordPolicy.setPwdMinAge(0);
            passwordPolicy.setPwdMaxAge(0);
            passwordPolicy.setPwdInHistory(5);
            passwordPolicy.setPwdCheckQuality(1);
            passwordPolicy.setPwdMinLength(5);
            passwordPolicy.setPwdMaxLength(0);
            passwordPolicy.setPwdExpireWarning(600);
            passwordPolicy.setPwdGraceAuthNLimit(5);
            passwordPolicy.setPwdGraceExpire(0);
            passwordPolicy.setPwdLockout(true);
            passwordPolicy.setPwdLockoutDuration(0);
            passwordPolicy.setPwdMaxFailure(5);
            passwordPolicy.setPwdFailureCountInterval(30);
            passwordPolicy.setPwdMustChange(false);
            passwordPolicy.setPwdAllowUserChange(true);
            passwordPolicy.setPwdMinDelay(0);
            passwordPolicy.setPwdMaxDelay(0);
            passwordPolicy.setPwdMaxIdle(0);
            passwordPolicy.setPwdValidator("org.apache.directory.server.core.api.authn.ppolicy.DefaultPasswordValidator");
            authenticationInterceptor.addPasswordPolicies(new PasswordPolicyBean[]{passwordPolicy});
        }
    }

    public static boolean isDefaultPasswordPolicy(PasswordPolicyBean passwordPolicy) {
        if (passwordPolicy != null) {
            return PASSWORD_POLICY_ID_DEFAULT.equalsIgnoreCase(passwordPolicy.getPwdId());
        }
        return false;
    }
}

