/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.search.Messages;
import org.apache.directory.studio.schemaeditor.view.views.SearchView;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;

public class SearchPage
extends DialogPage
implements ISearchPage {
    private ISearchPageContainer container;
    private Combo searchCombo;
    private Button aliasesButton;
    private Button oidButton;
    private Button descriptionButon;
    private Button superiorButton;
    private Button syntaxButton;
    private Button matchingRulesButton;
    private Button superiorsButton;
    private Button mandatoryAttributesButton;
    private Button optionalAttributesButton;
    private Button attributeTypesAndObjectClassesButton;
    private Button attributeTypesOnlyButton;
    private Button objectClassesOnly;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Label searchStringLabel = new Label(parent, 0);
        searchStringLabel.setText(Messages.getString("SearchPage.SearchString"));
        searchStringLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchCombo = new Combo(parent, 2052);
        this.searchCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.searchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SearchPage.this.validate();
            }
        });
        Composite searchInComposite = new Composite(parent, 0);
        GridLayout SearchInLayout = new GridLayout(3, true);
        SearchInLayout.marginBottom = 0;
        SearchInLayout.marginHeight = 0;
        SearchInLayout.marginLeft = 0;
        SearchInLayout.marginRight = 0;
        SearchInLayout.marginTop = 0;
        SearchInLayout.marginWidth = 0;
        searchInComposite.setLayout((Layout)SearchInLayout);
        searchInComposite.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        Group searchInGroup = new Group(searchInComposite, 0);
        searchInGroup.setLayout((Layout)new GridLayout());
        searchInGroup.setText(Messages.getString("SearchPage.SearchIn"));
        searchInGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.aliasesButton = new Button((Composite)searchInGroup, 32);
        this.aliasesButton.setText(Messages.getString("SearchPage.Aliases"));
        this.oidButton = new Button((Composite)searchInGroup, 32);
        this.oidButton.setText(Messages.getString("SearchPage.OID"));
        this.descriptionButon = new Button((Composite)searchInGroup, 32);
        this.descriptionButon.setText(Messages.getString("SearchPage.Description"));
        Group attributeTypesSearchInGroup = new Group(searchInComposite, 0);
        attributeTypesSearchInGroup.setText(Messages.getString("SearchPage.SearchInForAttribute"));
        attributeTypesSearchInGroup.setLayout((Layout)new GridLayout());
        attributeTypesSearchInGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.superiorButton = new Button((Composite)attributeTypesSearchInGroup, 32);
        this.superiorButton.setText(Messages.getString("SearchPage.Superior"));
        this.syntaxButton = new Button((Composite)attributeTypesSearchInGroup, 32);
        this.syntaxButton.setText(Messages.getString("SearchPage.Syntax"));
        this.matchingRulesButton = new Button((Composite)attributeTypesSearchInGroup, 32);
        this.matchingRulesButton.setText(Messages.getString("SearchPage.MatchingRules"));
        Group objectClassesSearchInGroup = new Group(searchInComposite, 0);
        objectClassesSearchInGroup.setText(Messages.getString("SearchPage.SearchInObject"));
        objectClassesSearchInGroup.setLayout((Layout)new GridLayout());
        objectClassesSearchInGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.superiorsButton = new Button((Composite)objectClassesSearchInGroup, 32);
        this.superiorsButton.setText(Messages.getString("SearchPage.Superiors"));
        this.mandatoryAttributesButton = new Button((Composite)objectClassesSearchInGroup, 32);
        this.mandatoryAttributesButton.setText(Messages.getString("SearchPage.MandatoryAttributes"));
        this.optionalAttributesButton = new Button((Composite)objectClassesSearchInGroup, 32);
        this.optionalAttributesButton.setText(Messages.getString("SearchPage.OptionalAttributes"));
        Group scopeGroup = new Group(parent, 0);
        scopeGroup.setText(Messages.getString("SearchPage.Scope"));
        scopeGroup.setLayout((Layout)new GridLayout());
        scopeGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.attributeTypesAndObjectClassesButton = new Button((Composite)scopeGroup, 16);
        this.attributeTypesAndObjectClassesButton.setText(Messages.getString("SearchPage.TypesAndClasses"));
        this.attributeTypesOnlyButton = new Button((Composite)scopeGroup, 16);
        this.attributeTypesOnlyButton.setText(Messages.getString("SearchPage.TypesOnly"));
        this.objectClassesOnly = new Button((Composite)scopeGroup, 16);
        this.objectClassesOnly.setText(Messages.getString("SearchPage.ClassesOnly"));
        this.initSearchStringHistory();
        this.initSearchIn();
        this.initSearchScope();
        this.searchCombo.setFocus();
        super.setControl((Control)parent);
    }

    private void initSearchStringHistory() {
        this.searchCombo.setItems(SearchPage.loadSearchStringHistory());
    }

    private void initSearchIn() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES) == null) {
            this.aliasesButton.setSelection(true);
        } else {
            this.aliasesButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES));
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID) == null) {
            this.oidButton.setSelection(true);
        } else {
            this.oidButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID));
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION) == null) {
            this.descriptionButon.setSelection(true);
        } else {
            this.descriptionButon.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION));
        }
        this.superiorButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIOR));
        this.syntaxButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SYNTAX));
        this.matchingRulesButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MATCHING_RULES));
        this.superiorsButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIORS));
        this.mandatoryAttributesButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MANDATORY_ATTRIBUTES));
        this.optionalAttributesButton.setSelection(settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OPTIONAL_ATTRIBUTES));
    }

    private void initSearchScope() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SCOPE) == null) {
            this.attributeTypesAndObjectClassesButton.setSelection(true);
        } else {
            switch (settings.getInt(PluginConstants.PREFS_SEARCH_PAGE_SCOPE)) {
                case 0: {
                    this.attributeTypesAndObjectClassesButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.attributeTypesOnlyButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.objectClassesOnly.setSelection(true);
                }
            }
        }
    }

    public boolean performAction() {
        ArrayList<SearchInEnum> searchIn = new ArrayList<SearchInEnum>();
        if (this.aliasesButton.getSelection()) {
            searchIn.add(SearchInEnum.ALIASES);
        }
        if (this.oidButton.getSelection()) {
            searchIn.add(SearchInEnum.OID);
        }
        if (this.descriptionButon.getSelection()) {
            searchIn.add(SearchInEnum.DESCRIPTION);
        }
        if (this.superiorButton.getSelection()) {
            searchIn.add(SearchInEnum.SUPERIOR);
        }
        if (this.syntaxButton.getSelection()) {
            searchIn.add(SearchInEnum.SYNTAX);
        }
        if (this.matchingRulesButton.getSelection()) {
            searchIn.add(SearchInEnum.MATCHING_RULES);
        }
        if (this.superiorsButton.getSelection()) {
            searchIn.add(SearchInEnum.SUPERIORS);
        }
        if (this.mandatoryAttributesButton.getSelection()) {
            searchIn.add(SearchInEnum.MANDATORY_ATTRIBUTES);
        }
        if (this.optionalAttributesButton.getSelection()) {
            searchIn.add(SearchInEnum.OPTIONAL_ATTRIBUTES);
        }
        int scope = 0;
        if (this.attributeTypesAndObjectClassesButton.getSelection()) {
            scope = 0;
        } else if (this.attributeTypesOnlyButton.getSelection()) {
            scope = 1;
        } else if (this.objectClassesOnly.getSelection()) {
            scope = 2;
        }
        try {
            SearchView searchView = (SearchView)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SearchView.ID);
            searchView.setSearchInput(this.searchCombo.getText(), searchIn.toArray(new SearchInEnum[0]), scope);
        }
        catch (PartInitException e) {
            PluginUtils.logError(Messages.getString("SearchPage.ErrorOpeningView"), e);
            ViewUtils.displayErrorMessageDialog(Messages.getString("SearchPage.Error"), Messages.getString("SearchPage.ErrorOpeningView"));
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public void setVisible(boolean visible) {
        this.validate();
        super.setVisible(visible);
    }

    private boolean isValid() {
        return this.searchCombo.getText() != null && !"".equals(this.searchCombo.getText());
    }

    private void validate() {
        this.container.setPerformActionEnabled(this.isValid());
    }

    public static void addSearchStringHistory(String value) {
        String[] history = SearchPage.loadSearchStringHistory();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(history));
        if (list.contains(value)) {
            list.remove(value);
        }
        list.add(0, value);
        while (list.size() > 10) {
            list.remove(list.size() - 1);
        }
        history = list.toArray(new String[list.size()]);
        Activator.getDefault().getDialogSettings().put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_HISTORY, history);
    }

    public static void removeSearchStringHistory(String value) {
        String[] history = SearchPage.loadSearchStringHistory();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(history));
        if (list.contains(value)) {
            list.remove(value);
        }
        history = list.toArray(new String[list.size()]);
        Activator.getDefault().getDialogSettings().put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_HISTORY, history);
    }

    public static String[] loadSearchStringHistory() {
        String[] history = Activator.getDefault().getDialogSettings().getArray(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_HISTORY);
        if (history == null) {
            history = new String[]{};
        }
        return history;
    }

    public static List<SearchInEnum> loadSearchIn() {
        ArrayList<SearchInEnum> searchScope = new ArrayList<SearchInEnum>();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES) == null) {
            searchScope.add(SearchInEnum.ALIASES);
        } else if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES)) {
            searchScope.add(SearchInEnum.ALIASES);
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID) == null) {
            searchScope.add(SearchInEnum.OID);
        } else if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID)) {
            searchScope.add(SearchInEnum.OID);
        }
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION) == null) {
            searchScope.add(SearchInEnum.DESCRIPTION);
        } else if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION)) {
            searchScope.add(SearchInEnum.DESCRIPTION);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIOR)) {
            searchScope.add(SearchInEnum.SUPERIOR);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SYNTAX)) {
            searchScope.add(SearchInEnum.SYNTAX);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MATCHING_RULES)) {
            searchScope.add(SearchInEnum.MATCHING_RULES);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIORS)) {
            searchScope.add(SearchInEnum.SUPERIORS);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MANDATORY_ATTRIBUTES)) {
            searchScope.add(SearchInEnum.MANDATORY_ATTRIBUTES);
        }
        if (settings.getBoolean(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OPTIONAL_ATTRIBUTES)) {
            searchScope.add(SearchInEnum.OPTIONAL_ATTRIBUTES);
        }
        return searchScope;
    }

    public static int loadScope() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(PluginConstants.PREFS_SEARCH_PAGE_SCOPE) == null) {
            return 0;
        }
        return settings.getInt(PluginConstants.PREFS_SEARCH_PAGE_SCOPE);
    }

    public static void saveSearchScope(List<SearchInEnum> scope) {
        if (scope != null && scope.size() > 0) {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_ALIASES, scope.contains((Object)SearchInEnum.ALIASES));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OID, scope.contains((Object)SearchInEnum.OID));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_DESCRIPTION, scope.contains((Object)SearchInEnum.DESCRIPTION));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIOR, scope.contains((Object)SearchInEnum.SUPERIOR));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SYNTAX, scope.contains((Object)SearchInEnum.SYNTAX));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MATCHING_RULES, scope.contains((Object)SearchInEnum.MATCHING_RULES));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_SUPERIORS, scope.contains((Object)SearchInEnum.SUPERIORS));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_MANDATORY_ATTRIBUTES, scope.contains((Object)SearchInEnum.MANDATORY_ATTRIBUTES));
            settings.put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_IN_OPTIONAL_ATTRIBUTES, scope.contains((Object)SearchInEnum.OPTIONAL_ATTRIBUTES));
        }
    }

    public static void clearSearchHistory() {
        Activator.getDefault().getDialogSettings().put(PluginConstants.PREFS_SEARCH_PAGE_SEARCH_HISTORY, new String[0]);
    }

    public static enum SearchInEnum {
        ALIASES,
        OID,
        DESCRIPTION,
        SUPERIOR,
        SYNTAX,
        MATCHING_RULES,
        SUPERIORS,
        MANDATORY_ATTRIBUTES,
        OPTIONAL_ATTRIBUTES;

    }
}

