/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.connection;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.ui.widgets.ConnectionConfiguration;
import org.apache.directory.studio.connection.ui.widgets.ConnectionWidget;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIConstants;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionViewActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionViewUniversalListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConnectionView
extends ViewPart {
    private ConnectionConfiguration configuration;
    private ConnectionViewActionGroup actionGroup;
    private ConnectionWidget mainWidget;
    private ConnectionViewUniversalListener universalListener;

    public static String getId() {
        return BrowserUIConstants.VIEW_CONNECTION_VIEW;
    }

    public void setFocus() {
        this.mainWidget.getViewer().getControl().setFocus();
    }

    public void dispose() {
        if (this.configuration != null) {
            this.actionGroup.dispose();
            this.actionGroup = null;
            this.configuration.dispose();
            this.configuration = null;
            this.universalListener.dispose();
            this.universalListener = null;
            this.mainWidget.dispose();
            this.mainWidget = null;
            this.getSite().setSelectionProvider(null);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, String.valueOf(BrowserUIConstants.PLUGIN_ID) + "." + "tools_connections_view");
        this.configuration = new ConnectionConfiguration();
        this.mainWidget = new ConnectionWidget(this.configuration, this.getViewSite().getActionBars());
        this.mainWidget.createWidget(composite);
        this.mainWidget.setInput((Object)ConnectionCorePlugin.getDefault().getConnectionFolderManager());
        this.actionGroup = new ConnectionViewActionGroup(this);
        this.actionGroup.fillToolBar(this.mainWidget.getToolBarManager());
        this.actionGroup.fillMenu(this.mainWidget.getMenuManager());
        this.actionGroup.enableGlobalActionHandlers(this.getViewSite().getActionBars());
        IMenuManager contextMenuManager = this.configuration.getContextMenuManager(this.mainWidget.getViewer());
        this.actionGroup.fillContextMenu(contextMenuManager);
        this.getSite().registerContextMenu((MenuManager)contextMenuManager, (ISelectionProvider)this.mainWidget.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.mainWidget.getViewer());
        this.universalListener = new ConnectionViewUniversalListener(this);
    }

    public void select(Object obj) {
        if (obj instanceof Connection) {
            Connection connection = (Connection)obj;
            this.mainWidget.getViewer().reveal((Object)connection);
            this.mainWidget.getViewer().refresh((Object)connection, true);
            this.mainWidget.getViewer().setSelection((ISelection)new StructuredSelection((Object)connection), true);
        }
    }

    public ConnectionViewActionGroup getActionGroup() {
        return this.actionGroup;
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConnectionWidget getMainWidget() {
        return this.mainWidget;
    }

    public ConnectionViewUniversalListener getUniversalListener() {
        return this.universalListener;
    }
}

