/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractLinkWithEditorAction
extends Action {
    private ViewPart viewPart;
    private IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            AbstractLinkWithEditorAction.this.registerPropertyListener(part);
        }

        public void partClosed(IWorkbenchPart part) {
            AbstractLinkWithEditorAction.this.unregisterPropertyListener(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source instanceof IEditorPart && propId == 1342730831) {
                AbstractLinkWithEditorAction.this.linkViewWithEditor((IWorkbenchPart)((IEditorPart)source));
            }
        }
    };

    private void registerListeners() {
        IEditorReference[] editorReferences;
        this.viewPart.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        IEditorReference[] iEditorReferenceArray = editorReferences = this.viewPart.getSite().getPage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            this.registerPropertyListener((IWorkbenchPart)editor);
            ++n2;
        }
    }

    private void registerPropertyListener(IWorkbenchPart part) {
        if (part instanceof EntryEditor || part instanceof SearchResultEditor) {
            part.addPropertyListener(this.propertyListener);
        }
    }

    private void unregisterListeners() {
        IEditorReference[] editorReferences;
        this.viewPart.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        IEditorReference[] iEditorReferenceArray = editorReferences = this.viewPart.getSite().getPage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            this.unregisterPropertyListener((IWorkbenchPart)editor);
            ++n2;
        }
    }

    private void unregisterPropertyListener(IWorkbenchPart part) {
        if (part instanceof EntryEditor || part instanceof SearchResultEditor) {
            part.removePropertyListener(this.propertyListener);
        }
    }

    public AbstractLinkWithEditorAction(ViewPart viewPart, String message) {
        super(message, 2);
        this.setImageDescriptor(BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/link_with_editor.gif"));
        this.setEnabled(true);
        this.setChecked(BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("browserLinkWithEditor"));
        this.viewPart = viewPart;
    }

    protected void init() {
        if (this.isChecked()) {
            this.registerListeners();
        }
    }

    public void run() {
        this.setChecked(this.isChecked());
        BrowserUIPlugin.getDefault().getPreferenceStore().setValue("browserLinkWithEditor", this.isChecked());
        if (this.isChecked()) {
            this.registerListeners();
            IEditorPart activeEditor = this.viewPart.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
            this.linkViewWithEditor((IWorkbenchPart)activeEditor);
        } else {
            this.unregisterListeners();
        }
    }

    protected abstract void linkViewWithEditor(IWorkbenchPart var1);

    public void dispose() {
        if (this.partListener != null && this.propertyListener != null) {
            this.unregisterListeners();
            this.propertyListener = null;
            this.partListener = null;
        }
        this.viewPart = null;
    }
}

