/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.common.core.jobs;

import org.apache.directory.studio.common.core.jobs.CommonCoreConstants;
import org.apache.directory.studio.common.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioJob<T extends StudioRunnableWithProgress>
extends Job {
    protected T[] runnables;

    public StudioJob(T ... runnables) {
        super(runnables[0].getName());
        this.runnables = runnables;
    }

    protected IStatus run(IProgressMonitor ipm) {
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        if (!monitor.errorsReported()) {
            try {
                T[] TArray = this.runnables;
                int n = this.runnables.length;
                int n2 = 0;
                while (n2 < n) {
                    T runnable = TArray[n2];
                    if (runnable instanceof StudioBulkRunnableWithProgress) {
                        StudioBulkRunnableWithProgress bulkRunnable = (StudioBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                    } else {
                        runnable.run(monitor);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(this.runnables[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
    }

    protected void resumeEventFiringInCurrentThread() {
    }

    public void execute() {
        this.setUser(true);
        this.schedule();
    }

    public boolean shouldSchedule() {
        T[] TArray = this.runnables;
        int n = this.runnables.length;
        int n2 = 0;
        while (n2 < n) {
            Job[] jobs;
            T runnable = TArray[n2];
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = this.getLockIdentifiers(myLockedObjects);
            Job[] jobArray = jobs = StudioJob.getJobManager().find(null);
            int n3 = jobs.length;
            int n4 = 0;
            while (n4 < n3) {
                Job job = jobArray[n4];
                if (job instanceof StudioJob) {
                    StudioJob otherJob = (StudioJob)job;
                    T[] TArray2 = otherJob.runnables;
                    int n5 = otherJob.runnables.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        T otherRunnable = TArray2[n6];
                        if (runnable.getClass() == otherRunnable.getClass() && runnable != otherRunnable) {
                            String[] otherLockedObjectIdentifiers;
                            Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                            String[] stringArray = otherLockedObjectIdentifiers = this.getLockIdentifiers(otherLockedObjects);
                            int n7 = otherLockedObjectIdentifiers.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                String other = stringArray[n8];
                                String[] stringArray2 = myLockedObjectsIdentifiers;
                                int n9 = myLockedObjectsIdentifiers.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    String myLockedObjectIdentifier = stringArray2[n10];
                                    if (other.startsWith(myLockedObjectIdentifier) || myLockedObjectIdentifier.startsWith(other)) {
                                        return false;
                                    }
                                    ++n10;
                                }
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return super.shouldSchedule();
    }

    protected String[] getLockIdentifiers(Object ... objects) {
        String[] identifiers = new String[objects.length];
        int i = 0;
        while (i < identifiers.length) {
            identifiers[i] = this.getLockIdentifier(objects[i]);
            ++i;
        }
        return identifiers;
    }

    private String getLockIdentifier(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public boolean belongsTo(Object family) {
        return this.getFamily().equals(family);
    }

    public Object getFamily() {
        return CommonCoreConstants.JOB_FAMILY_ID;
    }
}

