/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.lang.reflect.Array;

public class HistoryTracker<T> {
    T[] fHistory;
    CandidateEvaluator<T> fEvaluator;
    Navigator<T> fBrowsePoint;
    Navigator<T> fInsertionPoint;
    int fSize;
    boolean fUseCircularNavigation;

    public HistoryTracker(int historySize, Class<T> clazz, CandidateEvaluator<T> evaluator, boolean useCircularNavigation) {
        historySize = Math.max(historySize, 1);
        this.fHistory = (Object[])Array.newInstance(clazz, historySize);
        this.fEvaluator = evaluator;
        this.fUseCircularNavigation = useCircularNavigation;
        this.fBrowsePoint = new Navigator(this);
        this.fInsertionPoint = new Navigator(this);
    }

    public T browseBackward() {
        if (this.canGoBackward()) {
            this.fBrowsePoint.decr();
        }
        return this.getCurrentBrowsePoint();
    }

    public T browseForward() {
        if (this.canGoForward()) {
            this.fBrowsePoint.incr();
        }
        return this.getCurrentBrowsePoint();
    }

    private boolean canGoBackward() {
        return this.fSize > 0 && (this.fUseCircularNavigation || this.fBrowsePoint.getPriorIndex() != this.fInsertionPoint.getIndex());
    }

    private boolean canGoForward() {
        return this.fSize > 0 && (this.fUseCircularNavigation || this.fBrowsePoint.getIndex() != this.fInsertionPoint.getIndex());
    }

    public T getCurrentBrowsePoint() {
        return this.fBrowsePoint.currentItem();
    }

    public T getNext() {
        if (this.canGoForward()) {
            return this.getAt(this.fBrowsePoint.getNextIndex());
        }
        return this.fBrowsePoint.currentItem();
    }

    T getAt(int index) {
        if (this.fSize == 0) {
            return null;
        }
        int i = this.moddedIndex(index);
        return this.fHistory[i];
    }

    public T addOrReplace(T newItem) {
        T answer = null;
        int i = this.fInsertionPoint.getIndex();
        while (i > this.fInsertionPoint.getIndex() - this.fSize) {
            T candidate = this.getAt(i);
            if (candidate != null && this.fEvaluator.canReplace(newItem, candidate)) {
                answer = this.deleteAt(i);
            }
            --i;
        }
        T replaced = this.addLast(newItem);
        if (answer == null) {
            answer = replaced;
        }
        return answer;
    }

    private T addLast(T newItem) {
        if (newItem == null) {
            return this.deleteLast();
        }
        if (this.fSize >= this.fHistory.length) {
            this.fInsertionPoint.incr();
            this.fBrowsePoint.jumpTo(this.fInsertionPoint);
            return this.replaceAt(newItem, this.fInsertionPoint);
        }
        this.expand();
        this.fInsertionPoint.incr();
        this.fBrowsePoint.jumpTo(this.fInsertionPoint);
        return this.shiftInsert(newItem);
    }

    private T shiftInsert(T newItem) {
        T answer;
        T tmp = answer = this.replaceAt(newItem, this.fInsertionPoint);
        int i = this.fInsertionPoint.getIndex() + 1;
        while (i < this.fSize) {
            tmp = this.replaceAt(tmp, i);
            ++i;
        }
        return answer;
    }

    private T deleteAt(int index) {
        if (this.fSize == 0) {
            return null;
        }
        int modIndex = this.moddedIndex(index);
        T answer = this.replaceAt(null, modIndex);
        Object priorVal = null;
        int i = this.fSize - 1;
        while (i >= modIndex) {
            priorVal = this.replaceAt(priorVal, i);
            --i;
        }
        if (answer != null) {
            --this.fSize;
        }
        if (this.fInsertionPoint.getIndex() >= modIndex && this.fSize > 0) {
            this.fInsertionPoint.decr();
        }
        if (this.fBrowsePoint.getIndex() >= modIndex && this.fSize > 0) {
            this.fBrowsePoint.decr();
        }
        return answer;
    }

    public T deleteLast() {
        T answer = this.deleteAt(this.fInsertionPoint.getIndex());
        return answer;
    }

    private T replaceAt(T newItem, int index) {
        if (this.fSize == 0) {
            return null;
        }
        int i = this.moddedIndex(index);
        T replaced = this.getAt(i);
        this.fHistory[i] = newItem;
        return replaced;
    }

    private T replaceAt(T newItem, Navigator<T> navigator) {
        return this.replaceAt(newItem, navigator.getIndex());
    }

    public T replaceLast(T newItem) {
        if (newItem == null) {
            return this.deleteLast();
        }
        this.fBrowsePoint.jumpTo(this.fInsertionPoint);
        return this.replaceAt(newItem, this.fInsertionPoint);
    }

    void expand() {
        this.fSize = Math.max(this.fSize, (this.fSize + 1) % (this.fHistory.length + 1));
    }

    private int moddedIndex(int index) {
        return Math.floorMod(index, this.fSize);
    }

    public boolean isEmpty() {
        return this.fInsertionPoint.currentItem() == null;
    }

    public int getSize() {
        return this.fSize;
    }

    public Navigator<T> navigator() {
        Navigator<T> answer = new Navigator<T>(this);
        answer.jumpTo(this.fInsertionPoint);
        return answer;
    }

    Navigator<T> navigator(int index) {
        Navigator answer = new Navigator(this);
        answer.jumpTo(index);
        return answer;
    }

    public boolean contains(T item) {
        if (item == null) {
            return false;
        }
        int i = 0;
        while (i < this.fSize) {
            if (item.equals(this.getAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isHealthy() {
        boolean priorWasNull = false;
        int flipCount = 0;
        int i = 0;
        while (i < this.fHistory.length) {
            boolean isNull;
            boolean bl = isNull = this.fHistory[i] == null;
            if (priorWasNull != isNull) {
                ++flipCount;
                priorWasNull = isNull;
            }
            ++i;
        }
        return flipCount < 2;
    }

    public static interface CandidateEvaluator<T> {
        public boolean canReplace(T var1, T var2);
    }

    public static class Navigator<T> {
        HistoryTracker<T> historyTracker;
        int fIndex;

        public Navigator(HistoryTracker<T> tracker) {
            this.historyTracker = tracker;
            this.fIndex = Math.floorMod(-1, tracker.fHistory.length);
        }

        void incr() {
            if (this.historyTracker.fSize == 0) {
                return;
            }
            this.fIndex = this.getNextIndex();
        }

        void decr() {
            if (this.historyTracker.fSize == 0) {
                return;
            }
            this.fIndex = this.getPriorIndex();
        }

        int getIndex() {
            return this.fIndex;
        }

        int getNextIndex() {
            return ((HistoryTracker)this.historyTracker).moddedIndex(this.fIndex + 1);
        }

        int getPriorIndex() {
            return ((HistoryTracker)this.historyTracker).moddedIndex(this.fIndex - 1);
        }

        public T currentItem() {
            return this.historyTracker.getAt(this.fIndex);
        }

        public T nextItem() {
            this.incr();
            return this.historyTracker.getAt(this.fIndex);
        }

        public T priorItem() {
            this.decr();
            return this.historyTracker.getAt(this.fIndex);
        }

        void jumpTo(Navigator<T> b) {
            this.fIndex = b.fIndex;
        }

        public void jumpTo(int index) {
            this.fIndex = ((HistoryTracker)this.historyTracker).moddedIndex(index);
        }
    }
}

