/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionRequestContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionRequestStates;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionRequestGrammar
extends AbstractGrammar<EndTransactionRequestContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EndTransactionRequestGrammar.class);
    private static Grammar<EndTransactionRequestContainer> instance = new EndTransactionRequestGrammar();

    public EndTransactionRequestGrammar() {
        this.setName(EndTransactionRequestGrammar.class.getName());
        this.transitions = new GrammarTransition[EndTransactionRequestStates.LAST_STATE.ordinal()][256];
        this.transitions[EndTransactionRequestStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition(EndTransactionRequestStates.START_STATE, EndTransactionRequestStates.SEQUENCE_STATE, UniversalTag.SEQUENCE, null);
        this.transitions[EndTransactionRequestStates.SEQUENCE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<EndTransactionRequestContainer>(EndTransactionRequestStates.SEQUENCE_STATE, EndTransactionRequestStates.COMMIT_STATE, UniversalTag.BOOLEAN, new GrammarAction<EndTransactionRequestContainer>("Set EndTransactionRequest commit flag"){

            @Override
            public void action(EndTransactionRequestContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    container.getEndTransactionRequest().setCommit(BooleanDecoder.parse(value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err(I18n.ERR_08221_BAD_END_TRANSACTION_COMMIT, Strings.dumpBytes(value.getData()), bde.getMessage()));
                    throw new DecoderException(bde.getMessage(), bde);
                }
            }
        });
        this.transitions[EndTransactionRequestStates.SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<EndTransactionRequestContainer>(EndTransactionRequestStates.SEQUENCE_STATE, EndTransactionRequestStates.IDENTFIER_STATE, UniversalTag.OCTET_STRING, new GrammarAction<EndTransactionRequestContainer>("Set EndTransactionRequest identifier"){

            @Override
            public void action(EndTransactionRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] identifier = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08206_IDENTIFIER, Strings.dumpBytes(identifier)));
                }
                if (identifier == null) {
                    identifier = Strings.EMPTY_BYTES;
                }
                container.getEndTransactionRequest().setTransactionId(identifier);
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[EndTransactionRequestStates.COMMIT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<EndTransactionRequestContainer>(EndTransactionRequestStates.COMMIT_STATE, EndTransactionRequestStates.IDENTFIER_STATE, UniversalTag.OCTET_STRING, new GrammarAction<EndTransactionRequestContainer>("Set EndTransactionRequest identifier"){

            @Override
            public void action(EndTransactionRequestContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] identifier = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08206_IDENTIFIER, Strings.dumpBytes(identifier)));
                }
                if (identifier == null) {
                    identifier = Strings.EMPTY_BYTES;
                }
                container.getEndTransactionRequest().setTransactionId(identifier);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<EndTransactionRequestContainer> getInstance() {
        return instance;
    }
}

