/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.kerberos;

import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StoreUtils.class);
    private static final Logger LOG_KRB = LoggerFactory.getLogger(Loggers.KERBEROS_LOG.getName());

    private StoreUtils() {
    }

    private static ExprNode getFilter(SchemaManager schemaManager, String principal) throws Exception {
        AttributeType type = schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName");
        Value value = new Value(type, principal);
        return new EqualityNode(type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry findPrincipalEntry(CoreSession session, Dn searchBaseDn, String principal) throws Exception {
        try (Cursor<Entry> cursor = null;){
            SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
            cursor = session.search(searchBaseDn, SearchScope.SUBTREE, StoreUtils.getFilter(schemaManager, principal), AliasDerefMode.DEREF_ALWAYS, "*");
            cursor.beforeFirst();
            if (cursor.next()) {
                Entry entry = cursor.get();
                LOG.debug("Found entry {} for kerberos principal name {}", (Object)entry.getDn(), (Object)principal);
                LOG_KRB.debug("Found entry {} for kerberos principal name {}", (Object)entry.getDn(), (Object)principal);
                while (cursor.next()) {
                    LOG.error(I18n.err(I18n.ERR_149, principal, cursor.next()));
                }
                Entry entry2 = entry;
                return entry2;
            }
            LOG.warn("No server entry found for kerberos principal name {}", (Object)principal);
            LOG_KRB.warn("No server entry found for kerberos principal name {}", (Object)principal);
            Entry entry = null;
            return entry;
        }
    }
}

