/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.variable;

import java.util.LinkedList;
import java.util.Map;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.qname.QualifiedNameMap;
import org.apache.torque.generator.variable.Variable;

public class VariableStore {
    private QualifiedNameMap<Variable> outletScope = new QualifiedNameMap();
    private LinkedList<QualifiedNameMap<Variable>> childrenScopeList = new LinkedList();
    private QualifiedNameMap<Variable> fileScope = new QualifiedNameMap();
    private QualifiedNameMap<Variable> globalScope = new QualifiedNameMap();

    public void set(Variable variable) {
        if (Variable.Scope.OUTLET.equals((Object)variable.getScope())) {
            this.outletScope.put(variable.getName(), variable);
        } else if (Variable.Scope.CHILDREN.equals((Object)variable.getScope())) {
            QualifiedNameMap<Variable> qualifiedNameMap = this.childrenScopeList.getLast();
            qualifiedNameMap.put(variable.getName(), variable);
        } else if (Variable.Scope.FILE.equals((Object)variable.getScope())) {
            this.fileScope.put(variable.getName(), variable);
        } else if (Variable.Scope.GLOBAL.equals((Object)variable.getScope())) {
            this.globalScope.put(variable.getName(), variable);
        }
    }

    public void remove(Variable variable) {
        if (Variable.Scope.OUTLET.equals((Object)variable.getScope())) {
            this.outletScope.remove(variable.getName());
        } else if (Variable.Scope.CHILDREN.equals((Object)variable.getScope())) {
            QualifiedNameMap<Variable> qualifiedNameMap = this.childrenScopeList.getLast();
            qualifiedNameMap.remove(variable.getName());
        } else if (Variable.Scope.FILE.equals((Object)variable.getScope())) {
            this.fileScope.remove(variable.getName());
        } else if (Variable.Scope.GLOBAL.equals((Object)variable.getScope())) {
            this.globalScope.remove(variable.getName());
        }
    }

    public void startOutlet() {
        this.childrenScopeList.addLast(new QualifiedNameMap());
    }

    public void endOutlet() {
        this.outletScope.clear();
        this.childrenScopeList.removeLast();
    }

    public void endFile() {
        this.fileScope.clear();
    }

    public void endGeneration() {
        this.clear();
    }

    public void clear() {
        this.outletScope.clear();
        this.childrenScopeList.clear();
        this.fileScope.clear();
        this.globalScope.clear();
    }

    public QualifiedNameMap<Variable> getContent() {
        QualifiedNameMap<Variable> result = new QualifiedNameMap<Variable>();
        result.putAll((Map<QualifiedName, Variable>)this.globalScope);
        result.putAll((Map<QualifiedName, Variable>)this.fileScope);
        for (QualifiedNameMap qualifiedNameMap : this.childrenScopeList) {
            result.putAll(qualifiedNameMap);
        }
        result.putAll((Map<QualifiedName, Variable>)this.outletScope);
        return result;
    }

    public Variable getInHierarchy(QualifiedName key) {
        Variable inOutletScope = this.outletScope.getInHierarchy(key);
        Variable inFileScope = this.fileScope.getInHierarchy(key);
        Variable inGenerationScope = this.globalScope.getInHierarchy(key);
        Variable result = null;
        for (QualifiedNameMap qualifiedNameMap : this.childrenScopeList) {
            Variable inChildrenScope = (Variable)qualifiedNameMap.getInHierarchy(key);
            result = this.getMoreSpecific(inChildrenScope, result);
        }
        result = this.getMoreSpecific(inOutletScope, result);
        result = this.getMoreSpecific(result, inFileScope);
        result = this.getMoreSpecific(result, inGenerationScope);
        return result;
    }

    private Variable getMoreSpecific(Variable variable1, Variable variable2) {
        if (variable1 == null) {
            return variable2;
        }
        if (variable2 == null) {
            return variable1;
        }
        Namespace variable1Namespace = variable1.getName().getNamespace();
        Namespace variable2Namespace = variable2.getName().getNamespace();
        if (variable2Namespace.isVisibleFrom(variable1Namespace)) {
            return variable1;
        }
        return variable2;
    }
}

