/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.utilXid;

public class XATestUtil {
    public static Xid getXid(int formatId, int b1, int b2) {
        int i;
        byte[] globalId = new byte[64];
        byte[] branchId = new byte[64];
        for (i = 0; i < globalId.length; ++i) {
            globalId[i] = (byte)(b1 + i);
        }
        for (i = 0; i < branchId.length; ++i) {
            branchId[i] = (byte)(b2 + i);
        }
        return XATestUtil.getXid(formatId, globalId, branchId);
    }

    public static Xid getXid(int formatId, byte[] globalId, byte[] branchId) {
        return new utilXid(formatId, globalId, branchId);
    }

    public static void dumpXAException(String tag, XAException xae) {
        System.out.println(tag + " : XAException - " + xae.getMessage() + " errorCode " + XATestUtil.errorCode(xae));
        xae.printStackTrace(System.out);
    }

    public static void createXATransactionView(Statement s) throws SQLException {
        s.execute("create view XATESTUTIL.global_xactTable as select  cast(global_xid as char(2)) as gxid, status,  CAST (case when first_instant is NULL then 'NULL' else 'false' end AS VARCHAR(8)) as readOnly,  cast (username as char(10)) as username, type  from syscs_diag.transaction_table");
    }

    public static void checkXATransactionView(Connection conn, String[][] expectedRows) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from XATESTUTIL.global_xactTable where gxid is not null order by gxid");
        if (expectedRows == null) {
            JDBC.assertEmpty(rs);
        } else {
            JDBC.assertUnorderedResultSet(rs, expectedRows);
        }
        rs.close();
    }

    public static String errorCode(XAException e) {
        String error;
        switch (e.errorCode) {
            case 7: {
                error = "XA_HEURCOM ";
                break;
            }
            case 8: {
                error = "XA_HEURHAZ";
                break;
            }
            case 5: {
                error = "XA_HEURMIX";
                break;
            }
            case 6: {
                error = "XA_HEURRB ";
                break;
            }
            case 9: {
                error = "XA_NOMIGRATE ";
                break;
            }
            case 101: {
                error = "XA_RBCOMMFAIL ";
                break;
            }
            case 102: {
                error = "XA_RBDEADLOCK ";
                break;
            }
            case 103: {
                error = "XA_RBINTEGRITY ";
                break;
            }
            case 104: {
                error = "XA_RBOTHER ";
                break;
            }
            case 105: {
                error = "XA_RBPROTO ";
                break;
            }
            case 100: {
                error = "XA_RBROLLBACK ";
                break;
            }
            case 106: {
                error = "XA_RBTIMEOUT ";
                break;
            }
            case 107: {
                error = "XA_RBTRANSIENT ";
                break;
            }
            case 3: {
                error = "XA_RDONLY ";
                break;
            }
            case 4: {
                error = "XA_RETRY ";
                break;
            }
            case -2: {
                error = "XAER_ASYNC ";
                break;
            }
            case -8: {
                error = "XAER_DUPID ";
                break;
            }
            case -5: {
                error = "XAER_INVAL ";
                break;
            }
            case -4: {
                error = "XAER_NOTA ";
                break;
            }
            case -9: {
                error = "XAER_OUTSIDE ";
                break;
            }
            case -6: {
                error = "XAER_PROTO ";
                break;
            }
            case -3: {
                error = "XAER_RMERR ";
                break;
            }
            case -7: {
                error = "XAER_RMFAIL ";
                break;
            }
            default: {
                error = Integer.toString(e.errorCode);
            }
        }
        return error;
    }
}

