/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.depend;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.depend.ProviderInfo;

public class BasicProviderInfo
implements ProviderInfo {
    private UUID uuid;
    private DependableFinder dFinder;
    private String providerName;

    public BasicProviderInfo() {
    }

    BasicProviderInfo(UUID uuid, DependableFinder dFinder, String providerName) {
        this.uuid = uuid;
        this.dFinder = dFinder;
        this.providerName = providerName;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.dFinder;
    }

    @Override
    public UUID getObjectId() {
        return this.uuid;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.uuid = (UUID)fh.get("uuid");
        this.dFinder = (DependableFinder)fh.get("dFinder");
        this.providerName = (String)fh.get("providerName");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("uuid", this.uuid);
        fh.put("dFinder", this.dFinder);
        fh.put("providerName", this.providerName);
        out.writeObject(fh);
    }

    @Override
    public int getTypeFormatId() {
        return 359;
    }

    public String toString() {
        String traceUUID = this.uuid == null ? "uuid: null " : "uuid: " + this.uuid + " ";
        String traceDFinder = this.dFinder == null ? "dFinder: null " : "dFinder: " + this.dFinder + " ";
        String traceProviderName = this.providerName == null ? "providerName: null " : "providerName: " + this.providerName + " ";
        return "ProviderInfo: (" + traceUUID + traceDFinder + traceProviderName + ")";
    }
}

