/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryNode;

class SubqueryList
extends QueryTreeNodeVector<SubqueryNode> {
    SubqueryList(ContextManager cm) {
        super(SubqueryNode.class, cm);
    }

    void addSubqueryNode(SubqueryNode subqueryNode) throws StandardException {
        this.addElement(subqueryNode);
    }

    void optimize(DataDictionary dataDictionary, double outerRows) throws StandardException {
        for (SubqueryNode sqn : this) {
            sqn.optimize(dataDictionary, outerRows);
        }
    }

    void modifyAccessPaths() throws StandardException {
        for (SubqueryNode sqn : this) {
            sqn.modifyAccessPaths();
        }
    }

    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        for (SubqueryNode sqn : this) {
            if (sqn.isMaterializable() || !sqn.getResultSet().referencesTarget(name, baseTable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        for (SubqueryNode sqn : this) {
            if (!sqn.referencesSessionSchema()) continue;
            return true;
        }
        return false;
    }

    void setPointOfAttachment(int pointOfAttachment) throws StandardException {
        for (SubqueryNode sqn : this) {
            sqn.setPointOfAttachment(pointOfAttachment);
        }
    }

    void decrementLevel(int decrement) {
        for (SubqueryNode sqn : this) {
            sqn.getResultSet().decrementLevel(decrement);
        }
    }

    void markHavingSubqueries() {
        for (SubqueryNode sqn : this) {
            sqn.setHavingSubquery(true);
        }
    }

    void markWhereSubqueries() {
        for (SubqueryNode sqn : this) {
            sqn.setWhereSubquery(true);
        }
    }
}

