/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Blob;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class SQLBinary
extends DataType
implements BitDataValue {
    static final byte PAD = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBinary.class);
    private static final int LEN_OF_BUFFER_TO_WRITE_BLOB = 1024;
    Blob _blobValue;
    byte[] dataValue;
    InputStream stream;
    int streamValueLength;

    @Override
    public int estimateMemoryUsage() {
        if (this.dataValue == null) {
            if (this.streamValueLength >= 0) {
                return BASE_MEMORY_USAGE + this.streamValueLength;
            }
            return this.getMaxMemoryUsage();
        }
        return BASE_MEMORY_USAGE + this.dataValue.length;
    }

    abstract int getMaxMemoryUsage();

    SQLBinary() {
    }

    SQLBinary(byte[] val) {
        this.dataValue = val;
    }

    SQLBinary(Blob val) {
        this.setValue(val);
    }

    @Override
    public final void setValue(byte[] theValue) {
        this.dataValue = theValue;
        this._blobValue = null;
        this.stream = null;
        this.streamValueLength = -1;
    }

    @Override
    public final void setValue(Blob theValue) {
        this.dataValue = null;
        this._blobValue = theValue;
        this.stream = null;
        this.streamValueLength = -1;
    }

    @Override
    public final String getString() throws StandardException {
        if (this.getValue() == null) {
            return null;
        }
        if (this.dataValue.length * 2 < 0) {
            throw StandardException.newException("22001", this.getTypeName(), "", String.valueOf(Integer.MAX_VALUE));
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    @Override
    public final InputStream getStream() throws StandardException {
        if (!this.hasStream()) {
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        return this.stream;
    }

    @Override
    public final byte[] getBytes() throws StandardException {
        return this.getValue();
    }

    byte[] getValue() throws StandardException {
        try {
            if (this.dataValue == null && this._blobValue != null) {
                this.dataValue = this._blobValue.getBytes(1L, this.getBlobLength());
                this._blobValue = null;
                this.stream = null;
                this.streamValueLength = -1;
            } else if (this.dataValue == null && this.stream != null) {
                if (this.stream instanceof FormatIdInputStream) {
                    this.readExternal((FormatIdInputStream)this.stream);
                } else {
                    this.readExternal(new FormatIdInputStream(this.stream));
                }
                this._blobValue = null;
                this.stream = null;
                this.streamValueLength = -1;
            }
        }
        catch (IOException ioe) {
            this.throwStreamingIOException(ioe);
        }
        catch (SQLException se) {
            throw StandardException.plainWrapException(se);
        }
        return this.dataValue;
    }

    @Override
    public final int getLength() throws StandardException {
        byte[] bytes;
        if (this._blobValue != null) {
            return this.getBlobLength();
        }
        if (this.stream != null) {
            if (this.streamValueLength != -1) {
                return this.streamValueLength;
            }
            if (this.stream instanceof Resetable) {
                try {
                    this.streamValueLength = SQLBinary.readBinaryLength((ObjectInput)((Object)this.stream));
                    if (this.streamValueLength == 0) {
                        this.streamValueLength = (int)InputStreamUtil.skipUntilEOF(this.stream);
                    }
                    int n = this.streamValueLength;
                    return n;
                }
                catch (IOException ioe) {
                    this.throwStreamingIOException(ioe);
                }
                finally {
                    try {
                        ((Resetable)((Object)this.stream)).resetStream();
                    }
                    catch (IOException ioe) {
                        this.throwStreamingIOException(ioe);
                    }
                }
            }
        }
        return (bytes = this.getBytes()) == null ? 0 : bytes.length;
    }

    private void throwStreamingIOException(IOException ioe) throws StandardException {
        throw StandardException.newException("XCL30.S", ioe, this.getTypeName());
    }

    @Override
    public final boolean isNull() {
        return this.dataValue == null && this.stream == null && this._blobValue == null;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        if (this._blobValue != null) {
            this.writeBlob(out);
            return;
        }
        int len = this.dataValue.length;
        this.writeLength(out, len);
        out.write(this.dataValue, 0, this.dataValue.length);
    }

    private void writeBlob(ObjectOutput out) throws IOException {
        try {
            int len = this.getBlobLength();
            InputStream is = this._blobValue.getBinaryStream();
            this.writeLength(out, len);
            int numOfBytes = 0;
            byte[] buffer = new byte[Math.min(len, 1024)];
            for (int bytesRead = 0; bytesRead < len; bytesRead += numOfBytes) {
                numOfBytes = is.read(buffer);
                if (numOfBytes == -1) {
                    throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
                }
                out.write(buffer, 0, numOfBytes);
            }
        }
        catch (StandardException se) {
            throw new IOException(se.getMessage());
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    private void writeLength(ObjectOutput out, int len) throws IOException {
        if (len <= 31) {
            out.write((byte)(0x80 | len & 0xFF));
        } else if (len <= 65535) {
            out.write(-96);
            out.writeShort((short)len);
        } else {
            out.write(-64);
            out.writeInt(len);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        this.stream = null;
        this.streamValueLength = -1;
        this._blobValue = null;
        int len = SQLBinary.readBinaryLength(in);
        if (len != 0) {
            this.dataValue = new byte[len];
            in.readFully(this.dataValue);
        } else {
            this.readFromStream((InputStream)((Object)in));
        }
    }

    private static int readBinaryLength(ObjectInput in) throws IOException {
        int len;
        int bl = in.read();
        if (bl == -1) {
            throw new EOFException();
        }
        byte li = (byte)bl;
        if ((li & 0xFFFFFF80) != 0) {
            len = li == -64 ? in.readInt() : (li == -96 ? in.readUnsignedShort() : li & 0x1F);
        } else {
            int v2 = in.read();
            int v3 = in.read();
            int v4 = in.read();
            if (v2 == -1 || v3 == -1 || v4 == -1) {
                throw new EOFException();
            }
            int lenInBits = (bl & 0xFF) << 24 | (v2 & 0xFF) << 16 | (v3 & 0xFF) << 8 | v4 & 0xFF;
            len = lenInBits / 8;
            if (lenInBits % 8 != 0) {
                ++len;
            }
        }
        return len;
    }

    private void readFromStream(InputStream in) throws IOException {
        int len;
        this.dataValue = null;
        byte[] tmpData = new byte[32768];
        int off = 0;
        while ((len = in.read(tmpData, off, tmpData.length - off)) != -1) {
            int available = Math.max(1, in.available());
            int extraSpace = available - (tmpData.length - (off += len));
            if (extraSpace <= 0) continue;
            int size = tmpData.length * 2;
            if (extraSpace > tmpData.length) {
                size += extraSpace;
            }
            byte[] grow = new byte[size];
            System.arraycopy(tmpData, 0, grow, 0, off);
            tmpData = grow;
        }
        this.dataValue = new byte[off];
        System.arraycopy(tmpData, 0, this.dataValue, 0, off);
    }

    @Override
    public final void restoreToNull() {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = null;
        this.streamValueLength = -1;
    }

    @Override
    public final boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls) {
            int otherTypeFormatId = other.getTypeFormatId();
            if (87 != otherTypeFormatId && 88 != otherTypeFormatId && 234 != otherTypeFormatId && 78 != otherTypeFormatId && 85 != otherTypeFormatId && 235 != otherTypeFormatId && (443 != otherTypeFormatId || 443 != this.getTypeFormatId())) {
                SanityManager.THROWASSERT("An object of type " + other.getClass().getName() + ", with format id " + otherTypeFormatId + ", was passed to SQLBinary.compare()");
            }
            if (this.isNull() || other.isNull()) {
                return unknownRV;
            }
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public final int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        if (this.isNull() || other.isNull()) {
            if (!this.isNull()) {
                return -1;
            }
            if (!other.isNull()) {
                return 1;
            }
            return 0;
        }
        return SQLBinary.compare(this.getBytes(), other.getBytes());
    }

    @Override
    public final DataValueDescriptor cloneHolder() {
        if (this.stream == null && this._blobValue == null) {
            return this.cloneValue(false);
        }
        SQLBinary self = (SQLBinary)this.getNewNull();
        if (this.stream != null) {
            self.setValue(this.stream, this.streamValueLength);
        } else if (this._blobValue != null) {
            self.setValue(this._blobValue);
        } else {
            throw new IllegalStateException("unknown BLOB value repr");
        }
        return self;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        try {
            DataValueDescriptor cloneDVD = this.getNewNull();
            cloneDVD.setValue(this.getValue());
            return cloneDVD;
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    @Override
    public final InputStream returnStream() {
        return this.stream;
    }

    @Override
    public final void setStream(InputStream newStream) {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = newStream;
        this.streamValueLength = -1;
    }

    @Override
    public final void loadStream() throws StandardException {
        this.getValue();
    }

    boolean objectNull(Object o) {
        if (o == null) {
            this.setToNull();
            return true;
        }
        return false;
    }

    @Override
    public final void setValue(InputStream theStream, int valueLength) {
        this.dataValue = null;
        this._blobValue = null;
        this.stream = theStream;
        this.streamValueLength = valueLength;
    }

    @Override
    protected final void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLBinary) {
            SQLBinary theValueBinary = (SQLBinary)theValue;
            this.dataValue = theValueBinary.dataValue;
            this._blobValue = theValueBinary._blobValue;
            this.stream = theValueBinary.stream;
            this.streamValueLength = theValueBinary.streamValueLength;
        } else {
            this.setValue(theValue.getBytes());
        }
    }

    @Override
    public final BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isEqual = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) == 0;
        return SQLBoolean.truthValue(left, right, isEqual);
    }

    @Override
    public final BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isNotEqual = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) != 0;
        return SQLBoolean.truthValue(left, right, isNotEqual);
    }

    @Override
    public final BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isLessThan = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) < 0;
        return SQLBoolean.truthValue(left, right, isLessThan);
    }

    @Override
    public final BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isGreaterThan = false;
        isGreaterThan = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) > 0;
        return SQLBoolean.truthValue(left, right, isGreaterThan);
    }

    @Override
    public final BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isLessEquals = false;
        isLessEquals = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) <= 0;
        return SQLBoolean.truthValue(left, right, isLessEquals);
    }

    @Override
    public final BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isGreaterEquals = false;
        isGreaterEquals = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) >= 0;
        return SQLBoolean.truthValue(left, right, isGreaterEquals);
    }

    @Override
    public final NumberDataValue charLength(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setValue(this.getValue().length);
        return result;
    }

    @Override
    public final BitDataValue concatenate(BitDataValue left, BitDataValue right, BitDataValue result) throws StandardException {
        if (result == null) {
            result = (BitDataValue)this.getNewNull();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        byte[] leftData = left.getBytes();
        byte[] rightData = right.getBytes();
        byte[] concatData = new byte[leftData.length + rightData.length];
        System.arraycopy(leftData, 0, concatData, 0, leftData.length);
        System.arraycopy(rightData, 0, concatData, leftData.length, rightData.length);
        result.setValue(concatData);
        return result;
    }

    @Override
    public final ConcatableDataValue substring(NumberDataValue start, NumberDataValue length, ConcatableDataValue result, int maxLen) throws StandardException {
        if (result == null) {
            result = new SQLVarbit();
        }
        BitDataValue varbitResult = (BitDataValue)result;
        if (this.isNull() || start.isNull() || length != null && length.isNull()) {
            varbitResult.setToNull();
            return varbitResult;
        }
        int startInt = start.getInt();
        int lengthInt = length != null ? length.getInt() : this.getLength() - startInt + 1;
        if (startInt <= 0 || lengthInt < 0 || startInt > this.getLength() || lengthInt > this.getLength() - startInt + 1) {
            throw StandardException.newException("22011", new Object[0]);
        }
        if (lengthInt < 0) {
            varbitResult.setToNull();
            return varbitResult;
        }
        if (startInt < 0) {
            if ((startInt += this.getLength()) < 0) {
                lengthInt += startInt;
                startInt = 0;
            }
            lengthInt = lengthInt + startInt > 0 ? (lengthInt += startInt) : 0;
        } else if (startInt > 0) {
            --startInt;
        }
        if (lengthInt == 0 || lengthInt <= 0 - startInt || startInt > this.getLength()) {
            varbitResult.setValue(new byte[0]);
            return varbitResult;
        }
        if (lengthInt >= this.getLength() - startInt) {
            byte[] substring = new byte[this.dataValue.length - startInt];
            System.arraycopy(this.dataValue, startInt, substring, 0, substring.length);
            varbitResult.setValue(substring);
        } else {
            byte[] substring = new byte[lengthInt];
            System.arraycopy(this.dataValue, startInt, substring, 0, substring.length);
            varbitResult.setValue(substring);
        }
        return varbitResult;
    }

    @Override
    public final void checkHostVariable(int declaredLength) throws StandardException {
        int variableLength = -1;
        if (this._blobValue != null) {
            variableLength = -1;
        } else if (this.stream == null) {
            if (this.dataValue != null) {
                variableLength = this.dataValue.length;
            }
        } else {
            variableLength = this.streamValueLength;
        }
        if (variableLength != -1 && variableLength > declaredLength) {
            throw StandardException.newException("22001", this.getTypeName(), MessageService.getTextMessage("BIN01", new Object[0]), String.valueOf(declaredLength));
        }
    }

    public final String toString() {
        if (this.dataValue == null) {
            if (this.stream == null && this._blobValue == null) {
                return "NULL";
            }
            SanityManager.THROWASSERT("value is null, stream or blob is not null");
            return "";
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final int hashCode() {
        int lastNonPadByte;
        try {
            if (this.getValue() == null) {
                return 0;
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return 0;
        }
        byte[] bytes = this.dataValue;
        for (lastNonPadByte = bytes.length - 1; lastNonPadByte >= 0 && bytes[lastNonPadByte] == 32; --lastNonPadByte) {
        }
        int hashcode = 0;
        for (int i = 0; i <= lastNonPadByte; ++i) {
            hashcode = hashcode * 31 + bytes[i];
        }
        return hashcode;
    }

    private static int compare(byte[] left, byte[] right) {
        int i;
        int minLen = left.length;
        byte[] longer = right;
        if (right.length < minLen) {
            minLen = right.length;
            longer = left;
        }
        for (i = 0; i < minLen; ++i) {
            int lb = left[i] & 0xFF;
            int rb = right[i] & 0xFF;
            if (lb == rb) continue;
            return lb - rb;
        }
        for (i = minLen; i < longer.length; ++i) {
            byte nb = longer[i];
            if (nb == 32) continue;
            if (left == longer) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setBytes(position, this.getBytes());
    }

    @Override
    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.hasStream()) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + ":Length=" + this.getLength();
    }

    private int getBlobLength() throws StandardException {
        try {
            long maxLength = Integer.MAX_VALUE;
            long length = this._blobValue.length();
            if (length > Integer.MAX_VALUE) {
                throw StandardException.newException("XJ093.S", Long.toString(length), Long.toString(maxLength));
            }
            return (int)length;
        }
        catch (SQLException se) {
            throw StandardException.plainWrapException(se);
        }
    }

    void truncate(int sourceWidth, int desiredWidth, boolean warn) throws StandardException {
        if (warn) {
            DataTruncation warning = new DataTruncation(-1, false, true, this.getLength(), desiredWidth);
            StatementContext statementContext = (StatementContext)DataValueFactoryImpl.getContext("StatementContext");
            statementContext.getActivation().getResultSet().addWarning(warning);
        }
        byte[] shrunkData = new byte[desiredWidth];
        System.arraycopy(this.getValue(), 0, shrunkData, 0, desiredWidth);
        this.setValue(shrunkData);
    }
}

