/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.RowUtil;

public final class DeferredConstraintsMemory {
    public static BackingStoreHashtable rememberDuplicate(LanguageConnectionContext lcc, BackingStoreHashtable deferredRowsHashTable, UUID constraintId, DataValueDescriptor[] insertRow) throws StandardException {
        int keyLength = insertRow.length - 1;
        if (deferredRowsHashTable == null) {
            HashMap<UUID, ValidationInfo> hashTables = lcc.getDeferredHashTables();
            ValidationInfo vi = hashTables.get(constraintId);
            if (vi == null) {
                deferredRowsHashTable = DeferredConstraintsMemory.makeDeferredHashTable(lcc.getTransactionExecute(), keyLength);
                hashTables.put(constraintId, new UniquePkInfo(deferredRowsHashTable, constraintId));
            } else {
                deferredRowsHashTable = vi.infoRows;
            }
        }
        DataValueDescriptor[] hashRowArray = new DataValueDescriptor[keyLength];
        System.arraycopy(insertRow, 0, hashRowArray, 0, keyLength);
        deferredRowsHashTable.putRow(true, hashRowArray, null);
        return deferredRowsHashTable;
    }

    public static BackingStoreHashtable rememberCheckViolations(LanguageConnectionContext lcc, UUID basetableId, String schemaName, String tableName, BackingStoreHashtable deferredCheckViolations, List<UUID> violatingCheckConstraints, RowLocation offendingRow, CheckInfo[] result) throws StandardException {
        if (violatingCheckConstraints.isEmpty()) {
            return null;
        }
        if (deferredCheckViolations == null) {
            HashMap<UUID, ValidationInfo> hashTables = lcc.getDeferredHashTables();
            CheckInfo vi = (CheckInfo)hashTables.get(basetableId);
            if (vi == null) {
                deferredCheckViolations = DeferredConstraintsMemory.makeDeferredHashTable(lcc.getTransactionExecute(), 1);
                CheckInfo ci = new CheckInfo(deferredCheckViolations, schemaName, tableName, violatingCheckConstraints);
                hashTables.put(basetableId, ci);
                result[0] = ci;
            } else {
                vi.addCulprits(violatingCheckConstraints);
                deferredCheckViolations = vi.infoRows;
                result[0] = vi;
            }
        }
        DataValueDescriptor[] hashRowArray = new DataValueDescriptor[]{new SQLRef(offendingRow).cloneValue(true)};
        deferredCheckViolations.putRow(true, hashRowArray, null);
        return deferredCheckViolations;
    }

    public static Enumeration<Object> getDeferredCheckConstraintLocations(Activation activation, UUID validatingBaseTableUUID) throws StandardException {
        CheckInfo ci = (CheckInfo)activation.getLanguageConnectionContext().getDeferredHashTables().get(validatingBaseTableUUID);
        return ci.infoRows.elements();
    }

    public static BackingStoreHashtable rememberFKViolation(LanguageConnectionContext lcc, BackingStoreHashtable deferredRowsHashTable, UUID fkId, DataValueDescriptor[] indexRow, String schemaName, String tableName) throws StandardException {
        if (deferredRowsHashTable == null) {
            HashMap<UUID, ValidationInfo> hashTables = lcc.getDeferredHashTables();
            ValidationInfo vi = hashTables.get(fkId);
            if (vi == null) {
                deferredRowsHashTable = DeferredConstraintsMemory.makeDeferredHashTable(lcc.getTransactionExecute(), indexRow.length);
                hashTables.put(fkId, new ForeignKeyInfo(deferredRowsHashTable, fkId, schemaName, tableName));
            } else {
                deferredRowsHashTable = vi.infoRows;
            }
        }
        DataValueDescriptor[] hashRowArray = new DataValueDescriptor[indexRow.length];
        System.arraycopy(indexRow, 0, hashRowArray, 0, indexRow.length);
        deferredRowsHashTable.putRow(true, hashRowArray, null);
        return deferredRowsHashTable;
    }

    private static BackingStoreHashtable makeDeferredHashTable(TransactionController tc, int cols) throws StandardException {
        int[] keyCols = new int[cols];
        for (int i = 0; i < cols; ++i) {
            keyCols[i] = i;
        }
        return new BackingStoreHashtable(tc, null, keyCols, true, -1L, -1L, -1, -1.0f, false, false);
    }

    public static void compressOrTruncate(LanguageConnectionContext lcc, UUID tableId, String tableName) throws StandardException {
        HashMap<UUID, ValidationInfo> vis = lcc.getDeferredHashTables();
        TableDescriptor td = lcc.getDataDictionary().getTableDescriptor(tableId);
        ValidationInfo vi = vis.get(tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", tableName);
        }
        if (vi != null && vi instanceof CheckInfo) {
            ((CheckInfo)vi).setInvalidatedRowLocations();
        }
    }

    private static class ForeignKeyInfo
    extends ValidationInfo {
        private final UUID fkId;
        private final String schemaName;
        private final String tableName;

        public ForeignKeyInfo(BackingStoreHashtable infoRows, UUID fkId, String schemaName, String tableName) {
            super(infoRows);
            this.fkId = fkId;
            this.tableName = tableName;
            this.schemaName = schemaName;
        }

        public UUID getFkId() {
            return this.fkId;
        }

        @Override
        public void possiblyValidateOnReturn(LanguageConnectionContext lcc, SQLSessionContext nested, SQLSessionContext caller) throws StandardException {
            if (lcc.isEffectivelyDeferred(caller, this.getFkId())) {
                return;
            }
            this.validateForeignKey(lcc, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext lcc, UUID constraintId, boolean rollbackOnError) throws StandardException {
            this.validateForeignKey(lcc, rollbackOnError);
        }

        private void validateForeignKey(LanguageConnectionContext lcc, boolean rollbackOnError) throws StandardException {
            TransactionController tc = lcc.getTransactionExecute();
            DataDictionary dd = lcc.getDataDictionary();
            ForeignKeyConstraintDescriptor cd = (ForeignKeyConstraintDescriptor)dd.getConstraintDescriptor(this.fkId);
            if (cd == null) {
                return;
            }
            ReferencedKeyConstraintDescriptor rcd = cd.getReferencedConstraint();
            long[] cids = new long[]{cd.getIndexConglomerateDescriptor(dd).getConglomerateNumber(), rcd.getIndexConglomerateDescriptor(dd).getConglomerateNumber()};
            Enumeration<Object> e = this.infoRows.elements();
            while (e.hasMoreElements()) {
                Object[] key = (DataValueDescriptor[])e.nextElement();
                GenericScanController indexSC = null;
                boolean violation = false;
                for (int idx = 0; idx < 2; ++idx) {
                    boolean sawException = false;
                    try {
                        indexSC = tc.openScan(cids[idx], false, 0, 6, 2, null, (DataValueDescriptor[])key, 1, null, (DataValueDescriptor[])key, -1);
                        if (idx == 0) {
                            if (!indexSC.next()) break;
                            continue;
                        }
                        if (indexSC.next()) {
                            continue;
                        }
                        violation = true;
                        continue;
                    }
                    catch (StandardException se) {
                        sawException = true;
                        throw se;
                    }
                    finally {
                        block18: {
                            try {
                                if (indexSC != null) {
                                    indexSC.close();
                                }
                            }
                            catch (StandardException ie) {
                                if (sawException) break block18;
                                throw ie;
                            }
                        }
                    }
                }
                if (!violation) continue;
                SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
                TableDescriptor td = dd.getTableDescriptor(this.tableName, sd, tc);
                TableDescriptor rtd = rcd.getTableDescriptor();
                throw StandardException.newException(rollbackOnError ? "23516.T.1" : "23517.S.1", cd.getConstraintName(), td.getQualifiedName(), rcd.getConstraintName(), rtd.getQualifiedName(), RowUtil.toString(key));
            }
        }
    }

    public static class CheckInfo
    extends ValidationInfo {
        private final String schemaName;
        private final String tableName;
        private List<UUID> culprits;
        private boolean invalidatedDueToCompress;

        public CheckInfo(BackingStoreHashtable infoRows, String schemaName, String tableName, List<UUID> culprits) {
            super(infoRows);
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.culprits = new ArrayList<UUID>(culprits);
        }

        public void setInvalidatedRowLocations() {
            this.invalidatedDueToCompress = true;
        }

        public boolean isInvalidated() {
            return this.invalidatedDueToCompress;
        }

        public void addCulprits(List<UUID> newCulprits) {
            HashSet<UUID> old = new HashSet<UUID>(this.culprits);
            old.addAll(newCulprits);
            this.culprits = new ArrayList<UUID>(old);
        }

        public List<UUID> getCulprints() {
            return this.culprits;
        }

        @Override
        public void possiblyValidateOnReturn(LanguageConnectionContext lcc, SQLSessionContext nested, SQLSessionContext caller) throws StandardException {
            boolean allEffectivelyDeferred = true;
            for (UUID uid : this.getCulprints()) {
                if (lcc.isEffectivelyDeferred(caller, uid) || !lcc.isEffectivelyDeferred(nested, uid)) continue;
                allEffectivelyDeferred = false;
                break;
            }
            if (allEffectivelyDeferred) {
                return;
            }
            this.validateCheck(lcc, null, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext lcc, UUID constraintId, boolean rollbackOnError) throws StandardException {
            this.validateCheck(lcc, constraintId, rollbackOnError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void validateCheck(LanguageConnectionContext lcc, UUID constraintId, boolean rollbackOnError) throws StandardException {
            TransactionController tc = lcc.getTransactionExecute();
            DataDictionary dd = lcc.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
            if (sd == null) {
                return;
            }
            TableDescriptor td = dd.getTableDescriptor(this.tableName, sd, tc);
            if (td != null) {
                String baseTableUUIDString = td.getUUID().toString();
                for (UUID id : this.culprits) {
                    if (constraintId != null && !constraintId.equals(id)) continue;
                    ConstraintDescriptor cd = dd.getConstraintDescriptor(id);
                    if (cd == null) break;
                    StringBuilder checkStmt = new StringBuilder();
                    checkStmt.append("SELECT 1 FROM ");
                    checkStmt.append(td.getQualifiedName());
                    if (!this.isInvalidated()) {
                        checkStmt.append(" --DERBY-PROPERTIES joinStrategy=nestedLoop,                     index=null,                     validateCheckConstraint=");
                        checkStmt.append(baseTableUUIDString);
                        checkStmt.append('\n');
                    }
                    checkStmt.append(" WHERE NOT(");
                    checkStmt.append(cd.getConstraintText());
                    checkStmt.append(')');
                    ResultSet rs = null;
                    PreparedStatement ps = lcc.prepareInternalStatement(lcc.getDefaultSchema(), checkStmt.toString(), true, true);
                    StatementContext statementContext = null;
                    try {
                        statementContext = lcc.pushStatementContext(true, true, checkStmt.toString(), null, false, 0L);
                        rs = (BasicNoPutResultSetImpl)ps.execute(ps.getActivation(lcc, false), false, 0L);
                        ExecRow row = ((BasicNoPutResultSetImpl)rs).getNextRowCore();
                        if (row != null) {
                            throw StandardException.newException(rollbackOnError ? "23514.T.1" : "23515.S.1", cd.getConstraintName(), td.getQualifiedName(), cd.getConstraintText());
                        }
                        if (statementContext != null) {
                            lcc.popStatementContext(statementContext, null);
                        }
                        if (rs == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (statementContext != null) {
                            lcc.popStatementContext(statementContext, null);
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (StandardException standardException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (StandardException standardException) {}
                }
            }
        }
    }

    private static class UniquePkInfo
    extends ValidationInfo {
        private final UUID constraintId;

        public UniquePkInfo(BackingStoreHashtable infoRows, UUID constraintId) {
            super(infoRows);
            this.constraintId = constraintId;
        }

        @Override
        public final void possiblyValidateOnReturn(LanguageConnectionContext lcc, SQLSessionContext nested, SQLSessionContext caller) throws StandardException {
            if (lcc.isEffectivelyDeferred(caller, this.constraintId)) {
                return;
            }
            this.validateUniquePK(lcc, this.infoRows, true);
        }

        @Override
        public final void validateConstraint(LanguageConnectionContext lcc, UUID constraintId, boolean rollbackOnError) throws StandardException {
            this.validateUniquePK(lcc, this.infoRows, rollbackOnError);
        }

        private void validateUniquePK(LanguageConnectionContext lcc, BackingStoreHashtable ht, boolean rollbackOnError) throws StandardException {
            TransactionController tc = lcc.getTransactionExecute();
            Enumeration<Object> e = ht.elements();
            DataDictionary dd = lcc.getDataDictionary();
            KeyConstraintDescriptor cd = (KeyConstraintDescriptor)dd.getConstraintDescriptor(this.constraintId);
            if (cd == null) {
                return;
            }
            long indexCID = cd.getIndexConglomerateDescriptor(dd).getConglomerateNumber();
            while (e.hasMoreElements()) {
                DataValueDescriptor[] key = (DataValueDescriptor[])e.nextElement();
                GenericScanController indexSC = null;
                boolean sawException = false;
                try {
                    indexSC = tc.openScan(indexCID, false, 0, 6, 3, null, key, 1, null, key, -1);
                    if (!indexSC.next() || !indexSC.next()) continue;
                    throw StandardException.newException(rollbackOnError ? "23506.T.1" : "23507.S.1", cd.getConstraintName(), cd.getTableDescriptor().getName());
                }
                catch (StandardException se) {
                    sawException = true;
                    throw se;
                }
                finally {
                    try {
                        if (indexSC == null) continue;
                        indexSC.close();
                    }
                    catch (StandardException ie) {
                        if (sawException) continue;
                        throw ie;
                    }
                }
            }
        }
    }

    public static abstract class ValidationInfo {
        public final BackingStoreHashtable infoRows;

        public ValidationInfo(BackingStoreHashtable infoRows) {
            this.infoRows = infoRows;
        }

        public abstract void possiblyValidateOnReturn(LanguageConnectionContext var1, SQLSessionContext var2, SQLSessionContext var3) throws StandardException;

        public abstract void validateConstraint(LanguageConnectionContext var1, UUID var2, boolean var3) throws StandardException;
    }
}

