/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class SetOperatorNode
extends TableOperatorNode {
    boolean all;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();
    private PredicateList leftOptPredicates;
    private PredicateList rightOptPredicates;
    private PredicateList pushedPredicates;
    private HashMap<Predicate, Predicate> leftScopedPreds;
    private HashMap<Predicate, Predicate> rightScopedPreds;

    SetOperatorNode(ResultSetNode leftResult, ResultSetNode rightResult, boolean all, Properties tableProperties, ContextManager cm) throws StandardException {
        super(leftResult, rightResult, tableProperties, cm);
        this.all = all;
        this.setResultColumns(this.leftResultSet.getResultColumns().copyListAndObjects());
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, PredicateList predList) throws StandardException {
        if (predList != null && !this.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        CostEstimate ce = this.getFinalCostEstimate();
        ResultSetNode topNode = (ResultSetNode)((Object)this.modifyAccessPath(outerTables));
        CollectNodesVisitor<UnionNode> cnv = new CollectNodesVisitor<UnionNode>(UnionNode.class);
        this.accept(cnv);
        boolean genPRN = false;
        for (UnionNode node : cnv.getList()) {
            if (!node.hasUnPushedPredicates()) continue;
            genPRN = true;
            break;
        }
        if (genPRN) {
            ProjectRestrictNode prnRSN = new ProjectRestrictNode(topNode, topNode.getResultColumns(), null, this.pushedPredicates, null, null, null, this.getContextManager());
            prnRSN.setCostEstimate(ce.cloneMe());
            prnRSN.setReferencedTableMap(topNode.getReferencedTableMap());
            topNode = prnRSN;
        }
        return (Optimizable)((Object)topNode);
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        boolean canPush;
        if (!(this instanceof UnionNode)) {
            return false;
        }
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.pushableToSubqueries()) {
            return false;
        }
        JBitSet tableNums = new JBitSet(this.getReferencedTableMap().size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tableNums);
        this.leftResultSet.accept(btnVis);
        boolean bl = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.rightResultSet.accept(btnVis);
        boolean bl2 = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.accept(btnVis);
        int[] whichRC = new int[]{-1};
        Predicate scopedPred = null;
        if (this.leftScopedPreds == null) {
            this.leftScopedPreds = new HashMap();
        } else {
            scopedPred = this.leftScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.leftResultSet, whichRC);
            this.leftScopedPreds.put(pred, scopedPred);
        }
        this.getLeftOptPredicateList().addOptPredicate(scopedPred);
        scopedPred = null;
        if (this.rightScopedPreds == null) {
            this.rightScopedPreds = new HashMap();
        } else {
            scopedPred = this.rightScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.rightResultSet, whichRC);
            this.rightScopedPreds.put(pred, scopedPred);
        }
        this.getRightOptPredicateList().addOptPredicate(scopedPred);
        if (this.pushedPredicates == null) {
            this.pushedPredicates = new PredicateList(this.getContextManager());
        }
        this.pushedPredicates.addOptPredicate(pred);
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.pushedPredicates == null) {
            return;
        }
        if (this.leftOptPredicates != null) {
            this.leftOptPredicates.removeAllElements();
        }
        if (this.rightOptPredicates != null) {
            this.rightOptPredicates.removeAllElements();
        }
        RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
        for (int i = 0; i < this.pushedPredicates.size(); ++i) {
            Predicate pred = (Predicate)this.pushedPredicates.getOptPredicate(i);
            if (pred.isScopedForPush()) {
                pred.getAndNode().accept(rcrv);
                continue;
            }
            optimizablePredicates.addOptPredicate(pred);
        }
        this.pushedPredicates.removeAllElements();
    }

    protected boolean hasUnPushedPredicates() {
        return this.leftOptPredicates != null && this.leftOptPredicates.size() > 0 || this.rightOptPredicates != null && this.rightOptPredicates.size() > 0;
    }

    @Override
    public String toString() {
        return "all: " + this.all + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printQueryExpressionSuffixClauses(depth, this.qec);
    }

    @Override
    void bindResultColumns(FromList fromListParam) throws StandardException {
        super.bindResultColumns(fromListParam);
        this.buildRCL();
    }

    @Override
    void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().visibleSize() != this.rightResultSet.getResultColumns().visibleSize()) {
            throw StandardException.newException("42X58", this.getOperatorName());
        }
        this.setResultColumns(this.leftResultSet.getResultColumns().copyListAndObjects());
        this.getResultColumns().removeGeneratedGroupingColumns();
        this.getResultColumns().removeOrderByColumns();
        this.getResultColumns().setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level, this.getOperatorName());
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
        if (rcl == null) {
            ResultColumnList lrcl = this.rightResultSet.getResultColumns();
            ResultColumnList rrcl = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(rrcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(lrcl);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(rcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(rcl);
        }
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor ttd, ResultColumnList tcl, boolean allowDefaults) throws StandardException {
        this.leftResultSet.replaceOrForbidDefaults(ttd, tcl, allowDefaults);
        this.rightResultSet.replaceOrForbidDefaults(ttd, tcl, allowDefaults);
    }

    int getParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        int numTypes = 0;
        for (int i = 0; i < types.length; ++i) {
            ResultColumn rc;
            if (types[i] != null || (rc = (ResultColumn)rrsn.getResultColumns().elementAt(i)).getExpression().requiresTypeFromContext()) continue;
            types[i] = rc.getExpression().getTypeServices();
            ++numTypes;
        }
        return numTypes;
    }

    void setParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        ResultColumnList rrcl = rrsn.getResultColumns();
        int rrclSize = rrcl.size();
        for (int index = 0; index < rrclSize; ++index) {
            ResultColumn rc = (ResultColumn)rrcl.elementAt(index);
            if (!rc.getExpression().requiresTypeFromContext()) continue;
            rc.getExpression().setType(types[index]);
        }
    }

    @Override
    public void bindExpressions(FromList fromList) throws StandardException {
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                obl.bindOrderByColumns(this);
                obl.pullUpOrderByColumns(this);
            }
            SetOperatorNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
        super.bindExpressions(fromList);
    }

    @Override
    void bindTargetExpressions(FromList fromListParam) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromListParam);
        this.rightResultSet.bindTargetExpressions(fromListParam);
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        this.qec.setOffset(offset);
        this.qec.setFetchFirst(fetchFirst);
        this.qec.setHasJDBCLimitClause(hasJDBClimitClause);
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        SetOperatorNode newTop = this;
        this.leftResultSet = this.leftResultSet.preprocess(numTables, gbl, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(numTables, gbl, fromList);
        this.setReferencedTableMap((JBitSet)this.leftResultSet.getReferencedTableMap().clone());
        this.getReferencedTableMap().or(this.rightResultSet.getReferencedTableMap());
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (!this.all && obl != null && obl.allAscending() && obl.isInOrderPrefix(this.getResultColumns())) {
                obl = null;
                this.qec.setOrderByList(i, null);
            }
            if (obl == null || obl.size() <= 1) continue;
            obl.removeDupColumns();
        }
        return newTop;
    }

    @Override
    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this.genProjectRestrict(numTables);
    }

    @Override
    void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
        this.rightResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.leftResultSet.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    ResultSetNode setResultToBooleanTrueNode(boolean onlyConvertAlls) throws StandardException {
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addFromTable(this);
        fromList.markAsTransparent();
        ResultColumnList rcl = new ResultColumnList(this.getContextManager());
        AllResultColumn allResultColumn = new AllResultColumn(null, this.getContextManager());
        rcl.addResultColumn(allResultColumn);
        SelectNode result = new SelectNode(rcl, fromList, null, null, null, null, null, this.getContextManager());
        return result.setResultToBooleanTrueNode(onlyConvertAlls);
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    abstract String getOperatorName();

    PredicateList getLeftOptPredicateList() throws StandardException {
        if (this.leftOptPredicates == null) {
            this.leftOptPredicates = new PredicateList(this.getContextManager());
        }
        return this.leftOptPredicates;
    }

    PredicateList getRightOptPredicateList() throws StandardException {
        if (this.rightOptPredicates == null) {
            this.rightOptPredicates = new PredicateList(this.getContextManager());
        }
        return this.rightOptPredicates;
    }
}

