/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.DataToSketch;
import org.apache.datasketches.pig.theta.Estimate;
import org.apache.datasketches.pig.theta.PigUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchTest {
    private String udfName = "org.apache.datasketches.pig.theta.DataToSketch";
    private long seed_ = 9001L;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testConstructorExceptions1() {
        DataToSketch test = new DataToSketch("1023");
        Assert.assertNotNull((Object)test);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testConstructorExceptions3() {
        DataToSketch test = new DataToSketch("8");
        Assert.assertNotNull((Object)test);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testConstructorExceptions4() {
        DataToSketch test = new DataToSketch("1024", "2.0");
        Assert.assertNotNull((Object)test);
    }

    @Test
    public void checkNotDBAExcep() throws IOException {
        DataToSketch inter = new DataToSketch();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        inter.accumulate(inputTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        inter = new DataToSketch();
        inter.accumulate(inputTuple);
    }

    @Test
    public void checkConstructors() {
        DataToSketch inter = new DataToSketch();
        inter = new DataToSketch("1024");
        inter = new DataToSketch("1024", "1.0");
        inter = new DataToSketch("1024", "1.0", "9001");
        inter = new DataToSketch(1024, 1.0f, 9001L);
        DataToSketch.Initial initial = new DataToSketch.Initial();
        initial = new DataToSketch.Initial("1024");
        initial = new DataToSketch.Initial("1024", "1.0");
        initial = new DataToSketch.Initial("1024", "1.0", "9001");
        DataToSketch.IntermediateFinal interFin = new DataToSketch.IntermediateFinal();
        interFin = new DataToSketch.IntermediateFinal("1024");
        interFin = new DataToSketch.IntermediateFinal("1024", "1.0");
        interFin = new DataToSketch.IntermediateFinal("1024", "1.0", "9001");
        interFin = new DataToSketch.IntermediateFinal(1024, 1.0f, 9001L);
    }

    @Test
    public void testTopExec() throws IOException {
        DataToSketch func = new DataToSketch();
        Tuple inputTuple = null;
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertTrue((boolean)sketch.isEmpty());
        inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int ii = 0; ii < 64; ++ii) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)ii);
            bag.add(dataTuple);
        }
        resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)64.0, (double)0.0);
    }

    @Test
    public void textTopExec2() throws IOException {
        TupleFactory tupleFactory = TupleFactory.getInstance();
        BagFactory bagFactory = BagFactory.getInstance();
        String[] ctorArgs = new String[]{"128"};
        EvalFunc dataUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.udfName, ctorArgs));
        DataBag bag = bagFactory.newDefaultBag();
        bag.add(tupleFactory.newTuple());
        bag.add(tupleFactory.newTuple(1));
        Tuple t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Byte(1));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Integer(2));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Long(3L));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Float(4.0f));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Double(5.0));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        byte[] bArr = new byte[]{1, 2, 3};
        t.set(0, (Object)new DataByteArray(bArr));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        byte[] bArr2 = new byte[]{};
        t.set(0, (Object)new DataByteArray(bArr2));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Double(-0.0));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        t.set(0, (Object)new Double(0.0));
        bag.add(t);
        t = tupleFactory.newTuple(1);
        String s = "abcde";
        t.set(0, (Object)s);
        bag.add(t);
        t = tupleFactory.newTuple(1);
        String s2 = "";
        t.set(0, (Object)s2);
        bag.add(t);
        Tuple in = tupleFactory.newTuple(1);
        in.set(0, (Object)bag);
        Tuple resultTuple = (Tuple)dataUdf.exec(in);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)8.0, (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testRejectionOfNonSimpleType() throws IOException {
        TupleFactory mTupleFactory = TupleFactory.getInstance();
        BagFactory bagFactory = BagFactory.getInstance();
        Tuple outerTuple = mTupleFactory.newTuple(1);
        DataBag outerBag = bagFactory.newDefaultBag();
        Tuple innerTuple = mTupleFactory.newTuple(1);
        DataBag innerBag = bagFactory.newDefaultBag();
        innerTuple.set(0, (Object)innerBag);
        outerBag.add(innerTuple);
        outerTuple.set(0, (Object)outerBag);
        String[] ctorArgs = new String[]{"128"};
        EvalFunc dataUdf = (EvalFunc)PigContext.instantiateFuncFromSpec((FuncSpec)new FuncSpec(this.udfName, ctorArgs));
        dataUdf.exec(outerTuple);
    }

    @Test
    public void testAccumulate() throws IOException {
        Tuple dataTuple;
        int ii;
        DataToSketch func = new DataToSketch("128");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (ii = 0; ii < 64; ++ii) {
            dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)ii);
            bag.add(dataTuple);
        }
        func.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (ii = 0; ii < 27; ++ii) {
            dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)(64 + ii));
            bag.add(dataTuple);
        }
        func.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)91.0, (double)0.0);
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void testInitial() throws IOException {
        DataToSketch.Initial func = new DataToSketch.Initial("128");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int ii = 0; ii < 64; ++ii) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)ii);
            bag.add(dataTuple);
        }
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)64L);
    }

    @Test
    public void testIntermediateFinal() throws IOException {
        DataToSketch.IntermediateFinal func = new DataToSketch.IntermediateFinal("128");
        Tuple inputTuple = null;
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertTrue((boolean)sketch.isEmpty());
        inputTuple = TupleFactory.getInstance().newTuple(0);
        resultTuple = (Tuple)func.exec(inputTuple);
        sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertTrue((boolean)sketch.isEmpty());
        inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple contentsTuple = TupleFactory.getInstance().newTuple(1);
        DataBag contentsBag = BagFactory.getInstance().newDefaultBag();
        contentsTuple.set(0, (Object)contentsBag);
        for (int ii = 0; ii < 40; ++ii) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)ii);
            contentsBag.add(dataTuple);
        }
        Tuple intermediateTuple = TupleFactory.getInstance().newTuple(1);
        intermediateTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 40, 60));
        bag.add(contentsTuple);
        bag.add(intermediateTuple);
        resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)100.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalOuterBagEmptyTuples() throws IOException {
        DataToSketch.IntermediateFinal interFuncFinal = new DataToSketch.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalInnerBagEmpty() throws IOException {
        DataToSketch.IntermediateFinal interFuncFinal = new DataToSketch.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        DataBag bag2 = BagFactory.getInstance().newDefaultBag();
        innerTuple.set(0, (Object)bag2);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAlgFinalInnerNotDBA() throws IOException {
        DataToSketch.IntermediateFinal interFuncFinal = new DataToSketch.IntermediateFinal("256");
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test
    public void outputSchemaTest() throws IOException {
        DataToSketch udf = new DataToSketch("512");
        Schema inputSchema = null;
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema.FieldSchema outputInnerFs0 = null;
        inputSchema = Schema.generateNestedSchema((byte)120, (byte[])new byte[]{55});
        nullOutputSchema = udf.outputSchema(null);
        outputSchema = udf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        expected = "bytearray";
        Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS);
        DataToSketchTest.println(sb.toString());
    }

    @Test
    public void checkMisc() throws IOException {
        DataToSketch dts = new DataToSketch("512", "1.0");
        dts = new DataToSketch("512", "1.0", "9001");
        DataToSketch.Initial dtsi = new DataToSketch.Initial("512", "1.0");
        DataToSketch.IntermediateFinal dtsif = new DataToSketch.IntermediateFinal("512", "1.0");
        Assert.assertNotNull((Object)dtsi);
        Assert.assertNotNull((Object)dtsif);
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        dts.accumulate(inputTuple);
        Tuple resultTuple = dts.getValue();
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void checkSmall() throws IOException {
        DataToSketch func = new DataToSketch("32");
        Tuple inputTuple = null;
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Sketch sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertTrue((boolean)sketch.isEmpty());
        inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        int u = 32;
        for (int ii = 0; ii < u; ++ii) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)ii);
            bag.add(dataTuple);
        }
        resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        sketch = PigUtil.tupleToSketch((Tuple)resultTuple, (long)this.seed_);
        Assert.assertEquals((double)sketch.getEstimate(), (double)u, (double)0.0);
    }

    @Test
    public void printlnTest() {
        DataToSketchTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

