/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.pig.quantiles.GetQuantilesFromStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesFromStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void emptySketch() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.5)));
        Assert.assertNull((Object)resultTuple);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooFewInputs() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFractionOrNumberOfIntervals() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        sketch.update((Object)"a");
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), "")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeAmongFractions() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        sketch.update((Object)"a");
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.0, 1)));
    }

    @Test
    public void oneFraction() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        for (int i = 1; i <= 10; ++i) {
            sketch.update((Object)String.format("%02d", i));
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.5)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((String)((String)resultTuple.get(0)), (String)"06");
    }

    @Test
    public void severalFractions() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        for (int i = 1; i <= 10; ++i) {
            sketch.update((Object)String.format("%02d", i));
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.0, 0.5, 1.0)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((String)((String)resultTuple.get(0)), (String)"01");
        Assert.assertEquals((String)((String)resultTuple.get(1)), (String)"06");
        Assert.assertEquals((String)((String)resultTuple.get(2)), (String)"10");
    }

    @Test
    public void numberOfEvenlySpacedIntervals() throws Exception {
        GetQuantilesFromStringsSketch func = new GetQuantilesFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        for (int i = 1; i <= 10; ++i) {
            sketch.update((Object)String.format("%02d", i));
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 3)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((String)((String)resultTuple.get(0)), (String)"01");
        Assert.assertEquals((String)((String)resultTuple.get(1)), (String)"06");
        Assert.assertEquals((String)((String)resultTuple.get(2)), (String)"10");
    }
}

