/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectLongsSketch;
import org.apache.datasketches.kll.KllHeapLongsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.LongsSketchSortedView;
import org.apache.datasketches.quantilescommon.LongsSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDirectLongsTest {
    static final String LS = System.getProperty("line.separator");
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkBounds() {
        KllLongsSketch kll = KllMiscDirectLongsTest.getDirectLongsSketch(200, 0);
        for (int i = 0; i < 1000; ++i) {
            kll.update((long)i);
        }
        double eps = kll.getNormalizedRankError(false);
        long est = kll.getQuantile(0.5);
        long ub = kll.getQuantileUpperBound(0.5);
        long lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((long)ub, (long)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((long)lb, (long)kll.getQuantile(0.5 - eps));
        KllMiscDirectLongsTest.println("Ext     : " + est);
        KllMiscDirectLongsTest.println("UB      : " + ub);
        KllMiscDirectLongsTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    public void visualCheckToString() {
        int k = 20;
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(20, 0);
        for (int i = 0; i < 10; ++i) {
            sk.update((long)(i + 1));
        }
        KllMiscDirectLongsTest.println(sk.toString(true, true));
        KllLongsSketch sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(20, 0);
        for (int i = 0; i < 400; ++i) {
            sk2.update((long)(i + 1));
        }
        KllMiscDirectLongsTest.println("\n" + sk2.toString(true, true));
        sk2.merge((KllSketch)sk);
        String s2 = sk2.toString(true, true);
        KllMiscDirectLongsTest.println(LS + s2);
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int u = 108;
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (int i = 1; i <= u; ++i) {
            sk.update((long)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDirectLongsTest.println(sk.toString(true, true));
            sk.update((long)(++i));
            KllMiscDirectLongsTest.println(sk.toString(true, true));
            Assert.assertEquals((long)sk.getLongItemsArray()[sk.levelsArr[0]], (long)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int k = 20;
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        KllMiscDirectLongsTest.show(sk, 20);
        LongsSketchSortedView sv = sk.getSortedView();
        LongsSortedViewIterator itr = sv.iterator();
        KllMiscDirectLongsTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            long v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDirectLongsTest.printf("%12d%12d\n", v, wt);
        }
    }

    private static void show(KllLongsSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((long)(i + 1));
        }
        KllMiscDirectLongsTest.println(sk.toString(true, true));
    }

    @Test
    public void checkSketchInitializeLongHeap() {
        int k = 20;
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        sk.update(1L);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeLongHeapifyCompactMem() {
        int k = 20;
        KllLongsSketch sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((long)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllLongsSketch sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        sk2.update(1L);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllLongsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeLongHeapifyUpdatableMem() {
        int k = 20;
        KllLongsSketch sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((long)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllHeapLongsSketch sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((long)sk.getMaxItem(), (long)21L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        sk2.update(1L);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapLongsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getLongItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((long)sk.getMaxItem(), (long)1L);
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringLongUpdatable() {
        int k = 20;
        KllMiscDirectLongsTest.println("#### CASE: LONG FULL UPDATABLE");
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((long)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectLongsTest.println(s);
        KllLongsSketch sk2 = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectLongsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectLongsTest.println("#### CASE: LONG EMPTY UPDATABLE");
        sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectLongsTest.println(s);
        sk2 = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectLongsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectLongsTest.println("#### CASE: LONG SINGLE UPDATABL");
        sk = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        sk.update(1L);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectLongsTest.println(s);
        sk2 = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.LONGS_SKETCH, (boolean)true);
        KllMiscDirectLongsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectLongsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 21;
        KllLongsSketch sk1 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        KllLongsSketch sk2 = KllMiscDirectLongsTest.getDirectLongsSketch(k, 0);
        for (i = 1; i <= n1; ++i) {
            sk1.update((long)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((long)(i + 100));
        }
        KllMiscDirectLongsTest.println(sk1.toString(true, true));
        KllMiscDirectLongsTest.println(sk2.toString(true, true));
        sk1.merge((KllSketch)sk2);
        KllMiscDirectLongsTest.println(sk1.toString(true, true));
        Assert.assertEquals((long)sk1.getMaxItem(), (long)121L);
        Assert.assertEquals((long)sk1.getMinItem(), (long)1L);
    }

    @Test
    public void checkSizes() {
        KllLongsSketch sk = KllMiscDirectLongsTest.getDirectLongsSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int size1 = sk.currentSerializedSizeBytes(true);
        Assert.assertEquals((int)size1, (int)byteArr1.length);
        byte[] byteArr2 = sk.toByteArray();
        int size2 = sk.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)size2, (int)byteArr2.length);
    }

    @Test
    public void checkNewInstance() {
        int k = 200;
        WritableMemory dstMem = WritableMemory.allocate((int)3000);
        KllLongsSketch sk = KllLongsSketch.newDirectInstance((int)k, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk.getMaxItem(), (long)10000L);
    }

    @Test
    public void checkDifferentM() {
        int k = 20;
        int m = 4;
        WritableMemory dstMem = WritableMemory.allocate((int)1000);
        KllDirectLongsSketch sk = KllDirectLongsSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 200; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((long)sk.getMinItem(), (long)1L);
        Assert.assertEquals((long)sk.getMaxItem(), (long)200L);
    }

    private static KllLongsSketch getDirectLongsSketch(int k, int n) {
        KllLongsSketch sk = KllLongsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((long)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllLongsSketch dfsk = KllLongsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dfsk;
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDirectLongsTest.println(s);
        KllMiscDirectLongsTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

