/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

val root = (project in file("."))

val plugin = (project in file("plugin"))
  .settings(
    name := "test-plugin",
    version := "0.1",
    organization := "com.example",
    daffodilVersion := "3.10.0",
    daffodilBuildsCharset := true
  )
  .daffodilProject(crossDaffodilVersions = Seq("3.11.0", "4.0.0"))

val schema = (project in file("schema"))
  .settings(
    name := "test-schema",
    version := "0.1",
    organization := "com.example",
    daffodilVersion := "3.10.0",
    libraryDependencies ++= Seq(
      ("com.example" % "test-plugin" % "0.1").daffodilPlugin(daffodilVersion.value)
    ),
    daffodilPackageBinInfos := Seq(
      DaffodilBinInfo("/com/example/test.dfdl.xsd")
    )
  )
  .daffodilProject(crossDaffodilVersions = Seq("3.11.0", "4.0.0"))

val bundle = (project in file("bundle"))
  .settings(
    name := "test-bundle",
    version := "0.1",
    organization := "com.example",
    daffodilVersion := "3.10.0",
    libraryDependencies ++= Seq(
      ("com.example" % "test-plugin" % "0.1").daffodilPlugin(daffodilVersion.value),
      ("com.example" % "test-schema" % "0.1").daffodilBin(daffodilVersion.value)
    ),
    Compile / resourceGenerators += Def.task {
      // copy plugins and saved parsers to a "release" directory
      val srcFiles = update.value.matching(moduleFilter("com.example"))
      val destDir = (Compile / baseDirectory).value / "target" / "release"
      val destFiles = srcFiles.map { src =>
        val dest = destDir / src.getName()
        IO.copyFile(src, dest)
        dest
      }
      destFiles
    }.taskValue
  )
  .daffodilProject(crossDaffodilVersions = Seq("3.11.0", "4.0.0"))
