/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.slf4j;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.daffodil.slf4j.DaffodilLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class DaffodilLoggerFactory
implements ILoggerFactory {
    private final ConcurrentHashMap<String, DaffodilLogger> loggerMap = new ConcurrentHashMap();

    public Logger getLogger(String name) {
        DaffodilLogger daffodilLogger = this.loggerMap.get(name);
        if (daffodilLogger != null) {
            return daffodilLogger;
        }
        DaffodilLogger newInstance = new DaffodilLogger(name);
        DaffodilLogger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        if (oldInstance == null) {
            return newInstance;
        }
        return oldInstance;
    }
}

