/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;

public abstract class AbstractSequentialFileFactory
implements SequentialFileFactory {
    protected static final int EXECUTOR_TIMEOUT = 60;
    protected final File journalDir;
    protected final TimedBuffer timedBuffer;
    protected final int bufferSize;
    protected final long bufferTimeout;
    protected final int maxIO;
    protected boolean dataSync = true;
    protected volatile int alignment = -1;
    protected IOCriticalErrorListener critialErrorListener;
    protected final CriticalAnalyzer criticalAnalyzer;

    protected AbstractSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener criticalErrorListener, CriticalAnalyzer criticalAnalyzer) {
        this.journalDir = journalDir;
        if (criticalAnalyzer == null) {
            criticalAnalyzer = EmptyCriticalAnalyzer.getInstance();
        }
        this.criticalAnalyzer = criticalAnalyzer;
        if (buffered && bufferTimeout > 0) {
            this.timedBuffer = new TimedBuffer(criticalAnalyzer, bufferSize, bufferTimeout, logRates);
            criticalAnalyzer.add((CriticalComponent)this.timedBuffer);
        } else {
            this.timedBuffer = null;
        }
        this.bufferSize = bufferSize;
        this.bufferTimeout = bufferTimeout;
        this.critialErrorListener = criticalErrorListener;
        this.maxIO = maxIO;
    }

    @Override
    public IOCriticalErrorListener getCriticalErrorListener() {
        return this.critialErrorListener;
    }

    @Override
    public void setCriticalErrorListener(IOCriticalErrorListener listener) {
        this.critialErrorListener = listener;
    }

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.criticalAnalyzer;
    }

    @Override
    public long getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getAlignment() {
        if (this.alignment < 0) {
            this.alignment = 1;
        }
        return this.alignment;
    }

    @Override
    public AbstractSequentialFileFactory setAlignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    @Override
    public SequentialFileFactory setDatasync(boolean enabled) {
        this.dataSync = enabled;
        return this;
    }

    @Override
    public boolean isDatasync() {
        return this.dataSync;
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
    }

    @Override
    public File getDirectory() {
        return this.journalDir;
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public void onIOError(Throwable exception, String message, String file) {
        if (file != null) {
            ActiveMQJournalLogger.LOGGER.criticalIOFile(message, file, exception);
        } else {
            ActiveMQJournalLogger.LOGGER.criticalIO(message, exception);
        }
        if (this.critialErrorListener != null) {
            this.critialErrorListener.onIOException(exception, message, file);
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
        if (this.timedBuffer != null) {
            file.setTimedBuffer(this.timedBuffer);
        }
    }

    @Override
    public void flush() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
        }
    }

    @Override
    public void deactivateBuffer() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
            this.timedBuffer.setObserver(null);
        }
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
    }

    @Override
    public void createDirs() throws Exception {
        boolean ok = this.journalDir.mkdirs();
        if (!ok && !this.journalDir.exists()) {
            IOException e = new IOException("Unable to create directory: " + String.valueOf(this.journalDir));
            this.onIOError(e, e.getMessage());
            throw e;
        }
    }

    @Override
    public List<String> listFiles(String extension) throws Exception {
        FilenameFilter fnf = extension != null ? (file, name) -> name.endsWith("." + extension) : null;
        String[] fileNames = this.journalDir.list(fnf);
        if (fileNames == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(fileNames);
    }

    @Override
    public boolean deleteFolder() {
        return this.journalDir.delete();
    }
}

