/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.rp;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;
import org.apache.cxf.rs.security.oidc.rp.IdTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContext;
import org.apache.cxf.rs.security.oidc.rp.OidcClientTokenContextImpl;

@Path(value="rp")
public class OidcRpAuthenticationService {
    private ClientTokenContextManager stateManager;
    private String defaultLocation;
    @Context
    private MessageContext mc;

    @POST
    @Path(value="signin")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response completeScriptAuthentication(@Context IdTokenContext idTokenContext) {
        OidcClientTokenContextImpl ctx = new OidcClientTokenContextImpl();
        ctx.setIdToken(idTokenContext.getIdToken());
        return this.completeAuthentication(ctx);
    }

    @GET
    @Path(value="complete")
    public Response completeAuthentication(@Context OidcClientTokenContext oidcContext) {
        String location;
        this.stateManager.setClientTokenContext(this.mc, (ClientTokenContext)oidcContext);
        URI redirectUri = null;
        MultivaluedMap state = oidcContext.getState();
        String string = location = state != null ? (String)state.getFirst((Object)"state") : null;
        if (location == null && this.defaultLocation != null) {
            String basePath = (String)this.mc.get((Object)"http.base.path");
            redirectUri = UriBuilder.fromUri((String)basePath).path(this.defaultLocation).build(new Object[0]);
        } else if (location != null) {
            redirectUri = URI.create(UrlUtils.urlDecode((String)location));
        }
        if (redirectUri != null) {
            return Response.seeOther((URI)redirectUri).build();
        }
        return Response.ok((Object)oidcContext).build();
    }

    public void setDefaultLocation(String defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public void setClientTokenContextManager(ClientTokenContextManager manager) {
        this.stateManager = manager;
    }
}

