/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;

public class KeyInfoGeneratorManager {
    @Nonnull
    private final Map<Class<? extends Credential>, KeyInfoGeneratorFactory> factories = new HashMap<Class<? extends Credential>, KeyInfoGeneratorFactory>(5);

    public void registerFactory(@Nonnull KeyInfoGeneratorFactory factory) {
        this.factories.put(factory.getCredentialType(), factory);
    }

    public void deregisterFactory(@Nonnull KeyInfoGeneratorFactory factory) {
        this.factories.remove(factory.getCredentialType());
    }

    @Nonnull
    public Collection<KeyInfoGeneratorFactory> getFactories() {
        return CollectionSupport.copyToList(this.factories.values());
    }

    @Nullable
    public KeyInfoGeneratorFactory getFactory(@Nonnull Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Credential cannot be null");
        return this.factories.get(credential.getCredentialType());
    }
}

