/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class ConnectionFilterPredicate
extends ActiveMQFilterPredicate<RemotingConnection> {
    private ConnectionField f;
    private ActiveMQServer server;

    public ConnectionFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean test(RemotingConnection connection) {
        if (this.f == null) {
            return true;
        }
        return switch (this.f) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionField.CONNECTION_ID -> this.matches(connection.getID());
            case ConnectionField.CLIENT_ID -> this.matches(connection.getClientID());
            case ConnectionField.USERS -> this.matchAny(this.collectFromSessions(connection.getID().toString(), s -> s.getUsername()));
            case ConnectionField.PROTOCOL -> this.matches(connection.getProtocolName());
            case ConnectionField.SESSION_COUNT -> this.matches(this.server.getSessions(connection.getID().toString()).size());
            case ConnectionField.REMOTE_ADDRESS -> this.matches(connection.getTransportConnection().getRemoteAddress());
            case ConnectionField.LOCAL_ADDRESS -> this.matches(connection.getTransportConnection().getLocalAddress());
            case ConnectionField.SESSION_ID -> this.matchAny(this.server.getSessions(connection.getID().toString()));
            case ConnectionField.CREATION_TIME -> this.matches(connection.getCreationTime());
            case ConnectionField.IMPLEMENTATION -> this.matches(connection.getClass().getSimpleName());
        };
    }

    Set<String> collectFromSessions(String connectionId, Function<ServerSession, String> getter) {
        List<ServerSession> sessions = this.server.getSessions(connectionId);
        HashSet<String> sessionAttributes = new HashSet<String>();
        for (ServerSession session : sessions) {
            String value = getter.apply(session);
            String string = Objects.requireNonNullElse(value, "");
            sessionAttributes.add(string);
        }
        return sessionAttributes;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = ConnectionField.valueOfName(field);
            if (this.f == null) {
                this.f = ConnectionField.valueOf(field);
            }
        }
    }
}

