/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionProducerCreditsFailMessage
extends PacketImpl {
    private int credits;
    private SimpleString address;

    public SessionProducerCreditsFailMessage(int credits, SimpleString address) {
        super((byte)82);
        this.credits = credits;
        this.address = address;
    }

    public SessionProducerCreditsFailMessage() {
        super((byte)82);
    }

    public int getCredits() {
        return this.credits;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.credits);
        buffer.writeSimpleString(this.address);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.credits = buffer.readInt();
        this.address = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.address, this.credits);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", credits=" + this.credits);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionProducerCreditsFailMessage)) {
            return false;
        }
        SessionProducerCreditsFailMessage other = (SessionProducerCreditsFailMessage)obj;
        return Objects.equals(this.address, other.address) && this.credits == other.credits;
    }
}

