/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

public class AesWrapKeyEncryptionAlgorithm
extends AbstractWrapKeyEncryptionAlgorithm {
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList(KeyAlgorithm.A128KW.getJwaName(), KeyAlgorithm.A192KW.getJwaName(), KeyAlgorithm.A256KW.getJwaName()));

    public AesWrapKeyEncryptionAlgorithm(String encodedKey, KeyAlgorithm keyAlgoJwt) {
        this(CryptoUtils.decodeSequence((String)encodedKey), keyAlgoJwt);
    }

    public AesWrapKeyEncryptionAlgorithm(byte[] keyBytes, KeyAlgorithm keyAlgoJwt) {
        this(CryptoUtils.createSecretKeySpec((byte[])keyBytes, (String)keyAlgoJwt.getJavaName()), keyAlgoJwt);
    }

    public AesWrapKeyEncryptionAlgorithm(SecretKey key, KeyAlgorithm keyAlgoJwt) {
        super((Key)key, keyAlgoJwt, SUPPORTED_ALGORITHMS);
    }
}

