/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.databinding.source.mime.MimeAttribute;
import org.apache.cxf.javascript.ParticleInfo;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupParticle;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.w3c.dom.Attr;

public class JavascriptUtils {
    private static final XmlSchemaSequence EMPTY_SEQUENCE = new XmlSchemaSequence();
    private static final XmlSchemaChoice EMPTY_CHOICE = new XmlSchemaChoice();
    private static final XmlSchemaAll EMPTY_ALL = new XmlSchemaAll();
    private static final Logger LOG = LogUtils.getL7dLogger(JavascriptUtils.class);
    private static final String NL = "\n";
    private static final Map<String, String> DEFAULT_VALUE_FOR_SIMPLE_TYPE = new HashMap<String, String>();
    private static final Set<String> NON_STRINGS_SIMPLE_TYPES;
    private static final Set<String> INT_TYPES;
    private static final Set<String> FLOAT_TYPES;
    private static int anyTypePrefixCounter;
    private final StringBuilder code;
    private final Deque<String> prefixStack = new ArrayDeque<String>();
    private String xmlStringAccumulatorVariable;

    public JavascriptUtils(StringBuilder code) {
        this.code = code;
        this.prefixStack.push("    ");
    }

    public String getDefaultValueForSimpleType(XmlSchemaType type) {
        String val = DEFAULT_VALUE_FOR_SIMPLE_TYPE.get(type.getName());
        if (val == null) {
            return "''";
        }
        return val;
    }

    public boolean isStringSimpleType(QName typeName) {
        return !"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI()) || !NON_STRINGS_SIMPLE_TYPES.contains(typeName.getLocalPart());
    }

    public void setXmlStringAccumulator(String variableName) {
        this.xmlStringAccumulatorVariable = variableName;
    }

    public void startXmlStringAccumulator(String variableName) {
        this.xmlStringAccumulatorVariable = variableName;
        this.code.append(this.prefix());
        this.code.append("var ").append(variableName).append(" = '';").append(NL);
    }

    public static String protectSingleQuotes(String value) {
        return value.replaceAll("'", "\\'");
    }

    public String escapeStringQuotes(String data) {
        return data.replace("'", "\\'");
    }

    public void appendString(String value) {
        this.code.append(this.prefix());
        this.code.append(this.xmlStringAccumulatorVariable).append(" = ").append(this.xmlStringAccumulatorVariable).append(" + '");
        this.code.append(this.escapeStringQuotes(value));
        this.code.append("';").append(NL);
    }

    public void appendExpression(String value) {
        this.code.append(this.prefix());
        this.code.append(this.xmlStringAccumulatorVariable).append(" = ").append(this.xmlStringAccumulatorVariable).append(" + ");
        this.code.append(value);
        this.code.append(';').append(NL);
    }

    private String prefix() {
        return this.prefixStack.peek();
    }

    public void appendLine(String line) {
        this.code.append(this.prefix());
        this.code.append(line).append(NL);
    }

    public void startIf(String test) {
        this.code.append(this.prefix());
        this.code.append("if (").append(test).append(") {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startBlock() {
        this.code.append(this.prefix());
        this.code.append('{').append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void appendElse() {
        this.prefixStack.pop();
        this.code.append(this.prefix());
        this.code.append("} else {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void endBlock() {
        this.prefixStack.pop();
        this.code.append(this.prefix());
        this.code.append('}').append(NL);
    }

    public void startFor(String start, String test, String increment) {
        this.code.append(this.prefix());
        this.code.append("for (").append(start).append(';').append(test).append(';').append(increment).append(") {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startForIn(String var, String collection) {
        this.code.append(this.prefix());
        this.code.append("for (var ").append(var).append(" in ").append(collection).append(") {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startWhile(String test) {
        this.code.append(this.prefix());
        this.code.append("while (").append(test).append(") {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public void startDo() {
        this.code.append(this.prefix());
        this.code.append("do  {").append(NL);
        this.prefixStack.push(this.prefix() + " ");
    }

    public String javascriptParseExpression(XmlSchemaType type, String value) {
        if (!(type instanceof XmlSchemaSimpleType)) {
            return value;
        }
        String name = type.getName();
        if (INT_TYPES.contains(name)) {
            return "parseInt(" + value + ")";
        }
        if (FLOAT_TYPES.contains(name)) {
            return "parseFloat(" + value + ")";
        }
        if ("boolean".equals(name)) {
            return "(" + value + " == 'true')";
        }
        return value;
    }

    public static String javaScriptNameToken(String token) {
        return token;
    }

    private boolean treatAsMtom(XmlSchemaObject schemaObject) {
        Map attribMap;
        Attr ctAttr;
        if (schemaObject == null) {
            return false;
        }
        Map metaInfoMap = schemaObject.getMetaInfoMap();
        if (metaInfoMap != null && (ctAttr = (Attr)(attribMap = (Map)metaInfoMap.get("EXTERNAL_ATTRIBUTES")).get(MimeAttribute.MIME_QNAME)) != null) {
            return true;
        }
        if (schemaObject instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)schemaObject;
            if (element.getSchemaType() == null) {
                return false;
            }
            QName typeName = element.getSchemaType().getQName();
            if (new QName("http://www.w3.org/2005/05/xmlmime", "base64Binary").equals(typeName)) {
                return true;
            }
        }
        return false;
    }

    public static boolean notVeryComplexType(XmlSchemaType type) {
        return type instanceof XmlSchemaSimpleType || type instanceof XmlSchemaComplexType && ((XmlSchemaComplexType)type).getContentModel() instanceof XmlSchemaSimpleContent;
    }

    public static boolean mtomCandidateType(XmlSchemaType type) {
        XmlSchemaSimpleContentExtension extension;
        XmlSchemaSimpleContent content;
        XmlSchemaComplexType complexType;
        if (type == null) {
            return false;
        }
        if (Constants.XSD_BASE64.equals(type.getQName())) {
            return true;
        }
        return type instanceof XmlSchemaComplexType && (complexType = (XmlSchemaComplexType)type).getContentModel() instanceof XmlSchemaSimpleContent && (content = (XmlSchemaSimpleContent)complexType.getContentModel()).getContent() instanceof XmlSchemaSimpleContentExtension && Constants.XSD_BASE64.equals((extension = (XmlSchemaSimpleContentExtension)content.getContent()).getBaseTypeName());
    }

    public void generateCodeToSerializeElement(ParticleInfo elementInfo, String referencePrefix, SchemaCollection schemaCollection) {
        if (elementInfo.isGroup()) {
            for (ParticleInfo childElement : elementInfo.getChildren()) {
                this.generateCodeToSerializeElement(childElement, referencePrefix, schemaCollection);
            }
            return;
        }
        XmlSchemaType type = elementInfo.getType();
        boolean nillable = elementInfo.isNillable();
        boolean optional = elementInfo.isOptional();
        boolean array = elementInfo.isArray();
        boolean mtom = this.treatAsMtom((XmlSchemaObject)elementInfo.getParticle());
        String jsVar = referencePrefix + elementInfo.getJavascriptName();
        this.appendLine("// block for local variables");
        this.startBlock();
        if (optional) {
            this.startIf(jsVar + " != null");
        }
        if (nillable && !array) {
            this.startIf(jsVar + " == null");
            this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
            this.appendElse();
        }
        if (array) {
            this.startIf(jsVar + " != null");
            this.startFor("var ax = 0", "ax < " + jsVar + ".length", "ax ++");
            jsVar = jsVar + "[ax]";
            this.startIf(jsVar + " == null");
            if (nillable) {
                this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
            } else {
                this.appendString("<" + elementInfo.getXmlName() + "/>");
            }
            this.appendElse();
        }
        if (elementInfo.isAnyType()) {
            this.serializeAnyTypeElement(elementInfo, jsVar);
        } else if (!mtom && type instanceof XmlSchemaComplexType) {
            this.appendExpression(jsVar + ".serialize(cxfjsutils, '" + elementInfo.getXmlName() + "', null)");
        } else {
            this.appendString("<" + elementInfo.getXmlName() + ">");
            if (mtom) {
                this.appendExpression("cxfjsutils.packageMtom(" + jsVar + ")");
            } else {
                this.appendExpression("cxfjsutils.escapeXmlEntities(" + jsVar + ")");
            }
            this.appendString("</" + elementInfo.getXmlName() + ">");
        }
        if (array) {
            this.endBlock();
            this.endBlock();
            this.endBlock();
        }
        if (nillable && !array) {
            this.endBlock();
        }
        if (optional) {
            this.endBlock();
        }
        this.endBlock();
    }

    private void serializeAnyTypeElement(ParticleInfo elementInfo, String jsVar) {
        this.appendLine("var anyHolder = " + jsVar + ";");
        this.appendLine("var anySerializer;");
        this.appendLine("var typeAttr = '';");
        this.startIf("anyHolder != null");
        this.startIf("!anyHolder.raw");
        this.appendLine("anySerializer = cxfjsutils.interfaceObject.globalElementSerializers[anyHolder.qname];");
        this.endBlock();
        this.startIf("anyHolder.xsiType");
        this.appendLine("var typePrefix = 'cxfjst" + anyTypePrefixCounter + "';");
        ++anyTypePrefixCounter;
        this.appendLine("var typeAttr = 'xmlns:' + typePrefix + '=\\'' + anyHolder.namespaceURI + '\\'';");
        this.appendLine("typeAttr = typeAttr + ' xsi:type=\\'' + typePrefix + ':' + anyHolder.localName + '\\'';");
        this.endBlock();
        this.startIf("anySerializer");
        this.appendExpression(jsVar + ".serialize(cxfjsutils, '" + elementInfo.getXmlName() + "', typeAttr)");
        this.appendElse();
        this.appendExpression("'<" + elementInfo.getXmlName() + " ' + typeAttr + '>'");
        this.startIf("!anyHolder.raw");
        this.appendExpression("cxfjsutils.escapeXmlEntities(" + jsVar + ")");
        this.appendElse();
        this.appendExpression("anyHolder.xml");
        this.endBlock();
        this.appendString("</" + elementInfo.getXmlName() + ">");
        this.endBlock();
        this.appendElse();
        this.appendString("<" + elementInfo.getXmlName() + " " + "xsi:nil='true'" + "/>");
        this.endBlock();
    }

    public void generateCodeToSerializeAny(ParticleInfo itemInfo, String prefix, SchemaCollection schemaCollection) {
        boolean optional = XmlSchemaUtils.isParticleOptional((XmlSchemaParticle)itemInfo.getParticle()) || itemInfo.isArray() && itemInfo.getMinOccurs() == 0L;
        boolean array = XmlSchemaUtils.isParticleArray((XmlSchemaParticle)itemInfo.getParticle());
        this.appendLine("var anyHolder = this._" + itemInfo.getJavascriptName() + ";");
        this.appendLine("var anySerializer = null;");
        this.appendLine("var anyXmlTag = null;");
        this.appendLine("var anyXmlNsDef = null;");
        this.appendLine("var anyData = null;");
        this.appendLine("var anyStartTag;");
        this.startIf("anyHolder != null && !anyHolder.raw");
        this.appendLine("anySerializer = cxfjsutils.interfaceObject.globalElementSerializers[anyHolder.qname];");
        this.appendLine("anyXmlTag = '" + prefix + ":' + anyHolder.localName;");
        this.appendLine("anyXmlNsDef = 'xmlns:" + prefix + "=\\'' + anyHolder.namespaceURI + '\\'';");
        this.appendLine("anyStartTag = '<' + anyXmlTag + ' ' + anyXmlNsDef + '>';");
        this.appendLine("anyEndTag = '</' + anyXmlTag + '>';");
        this.appendLine("anyEmptyTag = '<' + anyXmlTag + ' ' + anyXmlNsDef + '/>';");
        this.appendLine("anyData = anyHolder.object;");
        this.endBlock();
        this.startIf("anyHolder != null && anyHolder.raw");
        this.appendExpression("anyHolder.xml");
        this.appendElse();
        if (optional) {
            this.startIf("anyHolder != null && anyData != null");
        } else {
            this.startIf("anyHolder == null || anyData == null");
            this.appendLine("throw 'null value for required any item';");
            this.endBlock();
        }
        String varRef = "anyData";
        if (array) {
            this.startFor("var ax = 0", "ax < anyData.length", "ax ++");
            varRef = "anyData[ax]";
            this.startIf(varRef + " == null");
            this.appendExpression("anyEmptyTag");
            this.appendElse();
        }
        this.startIf("anySerializer");
        this.appendExpression("anySerializer.call(" + varRef + ", cxfjsutils, anyXmlTag, anyXmlNsDef)");
        this.appendElse();
        this.appendExpression("anyStartTag");
        this.appendExpression("cxfjsutils.escapeXmlEntities(" + varRef + ")");
        this.appendExpression("anyEndTag");
        this.endBlock();
        if (array) {
            this.endBlock();
            this.endBlock();
        }
        if (optional) {
            this.endBlock();
        }
        this.endBlock();
    }

    public static XmlSchemaAnnotated getObjectAnnotated(XmlSchemaObject object, QName contextName) {
        if (!(object instanceof XmlSchemaAnnotated)) {
            throw JavascriptUtils.unsupportedConstruct("NON_ANNOTATED_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        if (!(object instanceof XmlSchemaAttribute) && !(object instanceof XmlSchemaAnyAttribute)) {
            throw JavascriptUtils.unsupportedConstruct("EXOTIC_ATTRIBUTE", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaAnnotated)object;
    }

    public static XmlSchemaParticle getObjectParticle(XmlSchemaObject object, QName contextName, XmlSchema currentSchema) {
        if (!(object instanceof XmlSchemaParticle)) {
            throw JavascriptUtils.unsupportedConstruct("NON_PARTICLE_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        if (object instanceof XmlSchemaGroupRef) {
            QName groupName = ((XmlSchemaGroupRef)object).getRefName();
            XmlSchemaGroup group = currentSchema.getGroupByName(groupName);
            if (group == null) {
                throw JavascriptUtils.unsupportedConstruct("MISSING_GROUP", groupName.toString(), contextName, null);
            }
            XmlSchemaGroupParticle groupParticle = group.getParticle();
            if (!(groupParticle instanceof XmlSchemaSequence)) {
                throw JavascriptUtils.unsupportedConstruct("GROUP_REF_UNSUPPORTED_TYPE", groupParticle.getClass().getSimpleName(), contextName, (XmlSchemaObject)groupParticle);
            }
            return groupParticle;
        }
        if (!(object instanceof XmlSchemaElement || object instanceof XmlSchemaAny || object instanceof XmlSchemaChoice || object instanceof XmlSchemaSequence)) {
            throw JavascriptUtils.unsupportedConstruct("GROUP_CHILD", object.getClass().getSimpleName(), contextName, object);
        }
        return (XmlSchemaParticle)object;
    }

    public static XmlSchemaSequence getSequence(XmlSchemaComplexType type) {
        XmlSchemaSequence sequence;
        XmlSchemaParticle particle = type.getParticle();
        if (particle == null) {
            return EMPTY_SEQUENCE;
        }
        try {
            sequence = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            throw JavascriptUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", (XmlSchemaType)type);
        }
        return sequence;
    }

    public static XmlSchemaChoice getChoice(XmlSchemaComplexType type) {
        XmlSchemaChoice choice;
        XmlSchemaParticle particle = type.getParticle();
        if (particle == null) {
            return EMPTY_CHOICE;
        }
        try {
            choice = (XmlSchemaChoice)particle;
        }
        catch (ClassCastException cce) {
            throw JavascriptUtils.unsupportedConstruct("NON_CHOICE_PARTICLE", (XmlSchemaType)type);
        }
        return choice;
    }

    public static XmlSchemaAll getAll(XmlSchemaComplexType type) {
        XmlSchemaAll all;
        XmlSchemaParticle particle = type.getParticle();
        if (particle == null) {
            return EMPTY_ALL;
        }
        try {
            all = (XmlSchemaAll)particle;
        }
        catch (ClassCastException cce) {
            throw JavascriptUtils.unsupportedConstruct("NON_CHOICE_PARTICLE", (XmlSchemaType)type);
        }
        return all;
    }

    public static List<XmlSchemaObject> getContentElements(XmlSchemaComplexType type, SchemaCollection collection) {
        ArrayList<XmlSchemaObject> results = new ArrayList<XmlSchemaObject>();
        QName baseTypeName = XmlSchemaUtils.getBaseType((XmlSchemaComplexType)type);
        if (baseTypeName != null) {
            XmlSchemaComplexType baseType = (XmlSchemaComplexType)collection.getTypeByQName(baseTypeName);
            results.addAll(JavascriptUtils.getContentElements(baseType, collection));
            XmlSchemaSequence extSequence = JavascriptUtils.getContentSequence(type);
            if (extSequence != null) {
                for (XmlSchemaSequenceMember item : extSequence.getItems()) {
                    results.add((XmlSchemaObject)item);
                }
            }
            return results;
        }
        XmlSchemaSequence sequence = JavascriptUtils.getSequence(type);
        for (XmlSchemaSequenceMember item : sequence.getItems()) {
            results.add((XmlSchemaObject)item);
        }
        return results;
    }

    public static XmlSchemaSequence getContentSequence(XmlSchemaComplexType type) {
        XmlSchemaSequence sequence;
        XmlSchemaContentModel model = type.getContentModel();
        if (model == null) {
            return null;
        }
        XmlSchemaContent content = model.getContent();
        if (content == null) {
            return null;
        }
        if (!(content instanceof XmlSchemaComplexContentExtension)) {
            return null;
        }
        XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content;
        XmlSchemaParticle particle = ext.getParticle();
        if (particle == null) {
            return null;
        }
        try {
            sequence = (XmlSchemaSequence)particle;
        }
        catch (ClassCastException cce) {
            throw JavascriptUtils.unsupportedConstruct("NON_SEQUENCE_PARTICLE", (XmlSchemaType)type);
        }
        return sequence;
    }

    static UnsupportedConstruct unsupportedConstruct(String messageKey, String what, QName subjectName, XmlSchemaObject subject) {
        Message message = new Message(messageKey, LOG, new Object[]{what, subjectName == null ? "anonymous" : subjectName, JavascriptUtils.cleanedUpSchemaSource(subject)});
        return new UnsupportedConstruct(message);
    }

    static UnsupportedConstruct unsupportedConstruct(String messageKey, XmlSchemaType subject) {
        Message message = new Message(messageKey, LOG, new Object[]{subject.getQName(), JavascriptUtils.cleanedUpSchemaSource((XmlSchemaObject)subject)});
        return new UnsupportedConstruct(message);
    }

    static String cleanedUpSchemaSource(XmlSchemaObject subject) {
        if (subject == null || subject.getSourceURI() == null) {
            return "";
        }
        return subject.getSourceURI() + ':' + subject.getLineNumber();
    }

    static {
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("int", "0");
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("unsignedInt", "0");
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("long", "0");
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("unsignedLong", "0");
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("float", "0.0");
        DEFAULT_VALUE_FOR_SIMPLE_TYPE.put("double", "0.0");
        NON_STRINGS_SIMPLE_TYPES = new HashSet<String>(Arrays.asList("int", "long", "unsignedInt", "unsignedLong", "float", "double"));
        INT_TYPES = new HashSet<String>(Arrays.asList("int", "long", "unsignedInt", "unsignedLong"));
        FLOAT_TYPES = new HashSet<String>(Arrays.asList("float", "double"));
    }
}

