/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.DefaultPOSSequenceValidator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;

public class POSTaggerFactory
extends BaseToolFactory {
    private static final String TAG_DICTIONARY_ENTRY_NAME = "tags.tagdict";
    private static final String NGRAM_DICTIONARY_ENTRY_NAME = "ngram.dictionary";
    protected Dictionary ngramDictionary;
    protected TagDictionary posDictionary;

    public POSTaggerFactory() {
    }

    public POSTaggerFactory(Dictionary ngramDictionary, TagDictionary posDictionary) {
        this.init(ngramDictionary, posDictionary);
    }

    protected void init(Dictionary ngramDictionary, TagDictionary posDictionary) {
        this.ngramDictionary = ngramDictionary;
        this.posDictionary = posDictionary;
    }

    @Override
    public Map<String, ArtifactSerializer> createArtifactSerializersMap() {
        Map<String, ArtifactSerializer> serializers = super.createArtifactSerializersMap();
        POSDictionarySerializer.register(serializers);
        return serializers;
    }

    @Override
    public Map<String, Object> createArtifactMap() {
        Map<String, Object> artifactMap = super.createArtifactMap();
        if (this.posDictionary != null) {
            artifactMap.put(TAG_DICTIONARY_ENTRY_NAME, this.posDictionary);
        }
        if (this.ngramDictionary != null) {
            artifactMap.put(NGRAM_DICTIONARY_ENTRY_NAME, this.ngramDictionary);
        }
        return artifactMap;
    }

    public TagDictionary createTagDictionary(File dictionary) throws IOException {
        return this.createTagDictionary(new FileInputStream(dictionary));
    }

    public TagDictionary createTagDictionary(InputStream in) throws IOException {
        return POSDictionary.create(in);
    }

    public void setTagDictionary(TagDictionary dictionary) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set tag dictionary while using artifact provider.");
        }
        this.posDictionary = dictionary;
    }

    public TagDictionary getTagDictionary() {
        if (this.posDictionary == null && this.artifactProvider != null) {
            this.posDictionary = (TagDictionary)this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        }
        return this.posDictionary;
    }

    public Dictionary getDictionary() {
        if (this.ngramDictionary == null && this.artifactProvider != null) {
            this.ngramDictionary = (Dictionary)this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME);
        }
        return this.ngramDictionary;
    }

    public void setDictionary(Dictionary ngramDict) {
        if (this.artifactProvider != null) {
            throw new IllegalStateException("Can not set ngram dictionary while using artifact provider.");
        }
        this.ngramDictionary = ngramDict;
    }

    public POSContextGenerator getPOSContextGenerator() {
        return new DefaultPOSContextGenerator(0, this.getDictionary());
    }

    public POSContextGenerator getPOSContextGenerator(int cacheSize) {
        return new DefaultPOSContextGenerator(cacheSize, this.getDictionary());
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DefaultPOSSequenceValidator(this.getTagDictionary());
    }

    protected void validatePOSDictionary(POSDictionary posDict, AbstractModel posModel) throws InvalidFormatException {
        HashSet dictTags = new HashSet();
        for (String word : posDict) {
            Collections.addAll(dictTags, posDict.getTags(word));
        }
        HashSet<String> modelTags = new HashSet<String>();
        for (int i = 0; i < posModel.getNumOutcomes(); ++i) {
            modelTags.add(posModel.getOutcome(i));
        }
        if (!modelTags.containsAll(dictTags)) {
            StringBuilder unknownTag = new StringBuilder();
            for (String d : dictTags) {
                if (modelTags.contains(d)) continue;
                unknownTag.append(d).append(" ");
            }
            throw new InvalidFormatException("Tag dictionary contains tags which are unknown by the model! The unknown tags are: " + unknownTag.toString());
        }
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
        Object ngramDictEntry;
        Object tagdictEntry = this.artifactProvider.getArtifact(TAG_DICTIONARY_ENTRY_NAME);
        if (tagdictEntry != null) {
            if (tagdictEntry instanceof POSDictionary) {
                if (!this.artifactProvider.isLoadedFromSerialized()) {
                    AbstractModel posModel = (AbstractModel)this.artifactProvider.getArtifact("pos.model");
                    POSDictionary posDict = (POSDictionary)tagdictEntry;
                    this.validatePOSDictionary(posDict, posModel);
                }
            } else {
                throw new InvalidFormatException("POSTag dictionary has wrong type!");
            }
        }
        if ((ngramDictEntry = this.artifactProvider.getArtifact(NGRAM_DICTIONARY_ENTRY_NAME)) != null && !(ngramDictEntry instanceof Dictionary)) {
            throw new InvalidFormatException("NGram dictionary has wrong type!");
        }
    }

    public static POSTaggerFactory create(String subclassName, Dictionary ngramDictionary, TagDictionary posDictionary) throws InvalidFormatException {
        if (subclassName == null) {
            return new POSTaggerFactory(ngramDictionary, posDictionary);
        }
        try {
            POSTaggerFactory theFactory = ExtensionLoader.instantiateExtension(POSTaggerFactory.class, subclassName);
            theFactory.init(ngramDictionary, posDictionary);
            return theFactory;
        }
        catch (Exception e) {
            String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
            System.err.println(msg);
            e.printStackTrace();
            throw new InvalidFormatException(msg, e);
        }
    }

    public TagDictionary createEmptyTagDictionary() {
        this.posDictionary = new POSDictionary(true);
        return this.posDictionary;
    }

    static class POSDictionarySerializer
    implements ArtifactSerializer<POSDictionary> {
        POSDictionarySerializer() {
        }

        @Override
        public POSDictionary create(InputStream in) throws IOException {
            return POSDictionary.create(new UncloseableInputStream(in));
        }

        @Override
        public void serialize(POSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }

        static void register(Map<String, ArtifactSerializer> factories) {
            factories.put("tagdict", new POSDictionarySerializer());
        }
    }
}

