/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.smokingstatus.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.ctakes.core.resource.FileResource;
import org.apache.ctakes.smokingstatus.ae.ResolutionAnnotator;
import org.apache.ctakes.smokingstatus.i2b2.type.RecordSentence;
import org.apache.ctakes.smokingstatus.type.SmokingDocumentClassification;
import org.apache.ctakes.smokingstatus.type.libsvm.NominalAttributeValue;
import org.apache.ctakes.smokingstatus.util.ClassifiableEntry;
import org.apache.ctakes.smokingstatus.util.TruthValue;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;

public class ClassifiableEntries
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SMOKING_STATUS_DESC_STEP1KEY = "UimaDescriptorStep1Key";
    public static final String PARAM_SMOKING_STATUS_DESC_STEP2KEY = "UimaDescriptorStep2Key";
    public static final String PARAM_TRUTH_FILE = "TruthFile";
    public static final String PARAM_TRUTH_FILE_DELIMITER = "TruthFileDelimiter";
    public static final String PARAM_ALLOWED_CLASSES = "AllowedClassifications";
    public static final String PARAM_PARSE_SECTIONS = "ParseSections";
    public static final String PARAM_IGNORE_SECTIONS = "SectionsToIgnore";
    private int iv_classifiableIdx;
    private List<ClassifiableEntry> iv_procEntryList;
    private List<Segment> iv_segList;
    private Map<String, List<ClassifiableEntry>> iv_entryIndexMap;
    private Map<Integer, TruthValue> iv_truthMap;
    private Set<String> iv_allowedClassifications;
    private AnalysisEngine taeStep1;
    private AnalysisEngine taeStep2;
    private ResourceSpecifier taeSpecifierStep1;
    private ResourceSpecifier taeSpecifierStep2;
    protected Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private int iSmokerCtr;
    private int iPastSmokerCtr;
    private int iCurrentCtr;
    private int iNonSmokerCtr;
    private int iUnknownCtr;
    private JCas jcas_local;
    private ResolutionAnnotator ra;
    private ResourceManager ResMgr;
    private Set<String> sectionsToIgnore;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        boolean windowsSystem = true;
        try {
            super.initialize(aContext);
            this.ResMgr = UIMAFramework.newDefaultResourceManager();
            this.iv_procEntryList = new ArrayList<ClassifiableEntry>();
            this.iv_entryIndexMap = new HashMap<String, List<ClassifiableEntry>>();
            this.iv_segList = new ArrayList<Segment>();
            this.initTruthData();
            if (System.getProperty("file.separator").matches("/")) {
                windowsSystem = false;
            }
            FileResource fResrc = (FileResource)aContext.getResourceObject(PARAM_SMOKING_STATUS_DESC_STEP1KEY);
            File descFile = fResrc.getFile();
            this.taeSpecifierStep1 = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(fResrc.getFile()));
            fResrc = (FileResource)aContext.getResourceObject(PARAM_SMOKING_STATUS_DESC_STEP2KEY);
            descFile = fResrc.getFile();
            this.taeSpecifierStep2 = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(fResrc.getFile()));
            this.ra = new ResolutionAnnotator();
            this.ra.initialize(aContext);
            String dataPath = aContext.getDataPath();
            System.out.println("descFile " + descFile.getAbsolutePath());
            this.taeStep1 = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)this.taeSpecifierStep1, (ResourceManager)this.ResMgr, null);
            this.taeStep2 = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)this.taeSpecifierStep2, (ResourceManager)this.ResMgr, null);
            this.jcas_local = CasCreationUtils.createCas((AnalysisEngineMetaData)this.taeStep1.getAnalysisEngineMetaData()).getJCas();
            String[] sections = (String[])this.getContext().getConfigParameterValue(PARAM_IGNORE_SECTIONS);
            this.sectionsToIgnore = new HashSet<String>();
            for (int i = 0; i < sections.length; ++i) {
                this.sectionsToIgnore.add(sections[i]);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void initTruthData() throws Exception {
        String truthFilePath = (String)this.getContext().getConfigParameterValue(PARAM_TRUTH_FILE);
        if (truthFilePath != null && truthFilePath.length() > 0) {
            String delimiter = "\t";
            File truthFile = new File(truthFilePath);
            this.loadTruthData(truthFile, delimiter);
            String[] allowedArr = (String[])this.getContext().getConfigParameterValue(PARAM_ALLOWED_CLASSES);
            this.iv_allowedClassifications = new HashSet<String>();
            for (int i = 0; i < allowedArr.length; ++i) {
                String classification = allowedArr[i];
                if (!(classification.equals("CURRENT_SMOKER") || classification.equals("NON_SMOKER") || classification.equals("PAST_SMOKER") || classification.equals("SMOKER") || classification.equals("UNKNOWN"))) {
                    throw new Exception("Invalid classification value for param AllowedClassifications:" + classification);
                }
                this.iv_allowedClassifications.add(classification);
            }
        }
    }

    private void loadTruthData(File truthFile, String delimiter) throws Exception {
        this.iv_truthMap = new HashMap<Integer, TruthValue>();
        BufferedReader br = new BufferedReader(new FileReader(truthFile));
        int lineNum = 1;
        String line = br.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, delimiter);
            if (st.countTokens() == 4) {
                Integer recordID = new Integer(st.nextToken().trim());
                String truthVal = st.nextToken().trim();
                String sentence = st.nextToken().trim();
                String ssClass = null;
                if (truthVal.equals("CURRENT SMOKER")) {
                    ssClass = "CURRENT_SMOKER";
                } else if (truthVal.equals("PAST SMOKER")) {
                    ssClass = "PAST_SMOKER";
                } else if (truthVal.equals("SMOKER")) {
                    ssClass = "SMOKER";
                } else if (truthVal.equals("NON-SMOKER")) {
                    ssClass = "NON_SMOKER";
                } else if (truthVal.equals("UNKNOWN")) {
                    ssClass = "UNKNOWN";
                } else {
                    throw new Exception("Invalid truth value for line:" + line);
                }
                TruthValue tVal = this.iv_truthMap.get(recordID);
                if (tVal == null) {
                    tVal = new TruthValue();
                    tVal.iv_sentenceList = new ArrayList();
                    tVal.iv_classification = ssClass;
                }
                tVal.iv_sentenceList.add(sentence);
                this.iv_truthMap.put(recordID, tVal);
            } else {
                this.iv_logger.warn((Object)("Malformed line " + lineNum + ": " + line));
            }
            line = br.readLine();
            ++lineNum;
        }
        br.close();
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info((Object)("Truth data loaded for " + this.iv_truthMap.keySet().size() + " records"));
        }
    }

    public void process(JCas jcas) {
        JFSIndexRepository indexes;
        FSIterator documentIDIterator;
        this.iv_entryIndexMap.clear();
        this.iv_procEntryList.clear();
        this.iv_segList.clear();
        ArrayList<ClassifiableEntry> entryList = new ArrayList<ClassifiableEntry>();
        String recordID = null;
        if (this.iv_logger.isInfoEnabled() && (documentIDIterator = (indexes = jcas.getJFSIndexRepository()).getAllIndexedFS(DocumentID.type)).hasNext()) {
            DocumentID didAnn = (DocumentID)((Object)documentIDIterator.next());
            recordID = didAnn.getDocumentID();
            if (this.iv_logger.isInfoEnabled()) {
                this.iv_logger.info((Object)("Processing record [" + recordID + "]"));
            }
        }
        for (Sentence sentAnn : jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type)) {
            FSIterator segItr = jcas.getJFSIndexRepository().getAnnotationIndex(Segment.type).iterator();
            Boolean skip = false;
            while (segItr.hasNext() && !skip.booleanValue()) {
                Segment segment = (Segment)((Object)segItr.next());
                if (segment.getBegin() > sentAnn.getBegin() || segment.getEnd() < sentAnn.getEnd() || !this.sectionsToIgnore.contains(segment.getId())) continue;
                skip = true;
            }
            if (skip.booleanValue()) continue;
            ClassifiableEntry entry = new ClassifiableEntry();
            entry.iv_recordID = recordID;
            entry.iv_begin = sentAnn.getBegin();
            entry.iv_end = sentAnn.getEnd();
            entry.iv_text = sentAnn.getCoveredText();
            entryList.add(entry);
        }
        for (Segment segAnn : jcas.getJFSIndexRepository().getAnnotationIndex(Segment.type)) {
            this.iv_segList.add(segAnn);
        }
        this.iv_entryIndexMap.put(recordID, entryList);
        this.buildProcEntryList();
        try {
            this.iv_classifiableIdx = 0;
            while (this.iv_classifiableIdx < this.iv_procEntryList.size()) {
                this.jcas_local.reset();
                ClassifiableEntry entry = this.iv_procEntryList.get(this.iv_classifiableIdx);
                RecordSentence rs = new RecordSentence(this.jcas_local);
                rs.setRecordID(entry.iv_recordID);
                rs.setBegin(0);
                rs.setRecordTextBegin(0);
                rs.setEnd(entry.iv_text.length());
                rs.setRecordTextEnd(entry.iv_text.length());
                this.jcas_local.setDocumentText(entry.iv_text);
                Segment sa = this.getSegment(entry);
                if (sa != null) {
                    Segment copy_sa = new Segment(this.jcas_local);
                    copy_sa.setBegin(rs.getBegin());
                    copy_sa.setEnd(rs.getEnd());
                    copy_sa.setId(sa.getId());
                    copy_sa.addToIndexes();
                } else if (this.iv_logger.isDebugEnabled()) {
                    this.iv_logger.error((Object)("Invalid Segment for sentence [" + rs.getCoveredText() + "]"));
                }
                if (entry.iv_classification != null) {
                    rs.setClassification(entry.iv_classification);
                }
                rs.addToIndexes();
                this.taeStep1.process(this.jcas_local);
                if (this.isSmokingStatusKnown(this.jcas_local)) {
                    this.taeStep2.process(this.jcas_local);
                }
                this.ra.process(this.jcas_local);
                this.performRecordResolution(this.jcas_local);
                ++this.iv_classifiableIdx;
            }
            this.collectionProcessComplete(jcas);
        }
        catch (Exception aep) {
            try {
                throw new AnnotatorProcessException((Throwable)aep);
            }
            catch (AnnotatorProcessException e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.taeStep1.destroy();
        this.taeStep2.destroy();
    }

    private boolean isSmokingStatusKnown(JCas jcas_local) {
        boolean known = true;
        for (NominalAttributeValue nav : jcas_local.getJFSIndexRepository().getAnnotationIndex(NominalAttributeValue.type)) {
            if (!nav.getAttributeName().equalsIgnoreCase("smoking_status") || !nav.getNominalValue().equalsIgnoreCase("UNKNOWN")) continue;
            known = false;
        }
        return known;
    }

    private Segment getSegment(ClassifiableEntry rs) {
        for (int i = 0; i < this.iv_segList.size(); ++i) {
            Segment sa = this.iv_segList.get(i);
            if (rs.iv_begin < sa.getBegin() || rs.iv_end > sa.getEnd()) continue;
            return sa;
        }
        return null;
    }

    private void performRecordResolution(JCas jcas_local) throws AnnotatorProcessException {
        try {
            FSIterator rsItr = jcas_local.getJFSIndexRepository().getAnnotationIndex(RecordSentence.type).iterator();
            if (rsItr.hasNext()) {
                for (NominalAttributeValue nav : jcas_local.getJFSIndexRepository().getAnnotationIndex(NominalAttributeValue.type)) {
                    String classification = nav.getNominalValue();
                    this.storeAssignedClasses(classification);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AnnotatorProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete(JCas jcas) throws ResourceProcessException, IOException {
        try {
            String finalClassification = this.resolveClassification();
            SmokingDocumentClassification docClass = new SmokingDocumentClassification(jcas);
            docClass.addToIndexes();
            docClass.setClassification(finalClassification);
            this.resetCounts();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    private String resolveClassification() {
        if (this.iUnknownCtr > 0 && this.iSmokerCtr == 0 && this.iPastSmokerCtr == 0 && this.iCurrentCtr == 0 && this.iNonSmokerCtr == 0) {
            return "UNKNOWN";
        }
        if (this.iNonSmokerCtr >= 1 && this.iUnknownCtr >= 0 && this.iPastSmokerCtr == 0 && this.iCurrentCtr == 0 && this.iSmokerCtr == 0) {
            return "NON_SMOKER";
        }
        if (this.iCurrentCtr >= 1) {
            return "CURRENT_SMOKER";
        }
        if (this.iPastSmokerCtr >= 1 && this.iCurrentCtr <= 0) {
            return "PAST_SMOKER";
        }
        if (this.iSmokerCtr >= 1 && this.iCurrentCtr <= 0 && this.iPastSmokerCtr <= 0) {
            return "SMOKER";
        }
        return null;
    }

    private void storeAssignedClasses(String smokClass) {
        if (smokClass.equals("CURRENT_SMOKER")) {
            ++this.iCurrentCtr;
        } else if (smokClass.equals("NON_SMOKER")) {
            ++this.iNonSmokerCtr;
        } else if (smokClass.equals("PAST_SMOKER")) {
            ++this.iPastSmokerCtr;
        } else if (smokClass.equals("SMOKER")) {
            ++this.iSmokerCtr;
        } else if (smokClass.equals("UNKNOWN")) {
            ++this.iUnknownCtr;
        }
    }

    private void resetCounts() {
        this.iSmokerCtr = 0;
        this.iPastSmokerCtr = 0;
        this.iCurrentCtr = 0;
        this.iNonSmokerCtr = 0;
        this.iUnknownCtr = 0;
    }

    private void buildProcEntryList() {
        int allowedCnt = 0;
        int disallowedCnt = 0;
        for (String recordID : this.iv_entryIndexMap.keySet()) {
            for (ClassifiableEntry entry : this.iv_entryIndexMap.get(recordID)) {
                if (this.iv_allowedClassifications == null || this.iv_allowedClassifications.contains(entry.iv_classification)) {
                    this.iv_procEntryList.add(entry);
                    ++allowedCnt;
                    continue;
                }
                if (this.iv_logger.isInfoEnabled()) {
                    this.iv_logger.info((Object)("disallowed value:" + entry.iv_classification));
                }
                ++disallowedCnt;
            }
        }
        int totalCnt = allowedCnt + disallowedCnt;
        if (this.iv_logger.isInfoEnabled()) {
            this.iv_logger.info((Object)("# total sentences: " + totalCnt));
            this.iv_logger.info((Object)("# allowed sentences: " + allowedCnt));
            this.iv_logger.info((Object)("# disallowed sentences: " + disallowedCnt));
        }
    }
}

