/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentTreeNode {
    private int level_ = -1;
    private long address_ = -1L;
    private long parent_ = -1L;
    private long child_ = -1L;
    private long next_ = -1L;

    public PersistentTreeNode() {
    }

    public PersistentTreeNode(long address) {
        this.address_ = address;
    }

    public PersistentTreeNode(int level, long parent, long next, long child, long address) {
        this.level_ = level;
        this.parent_ = parent;
        this.next_ = next;
        this.child_ = child;
        this.address_ = address;
    }

    public int GetLevel() {
        return this.level_;
    }

    public void SetLevel(int level) {
        this.level_ = level;
    }

    public long GetParent() {
        return this.parent_;
    }

    public void SetParent(long parent) {
        this.parent_ = parent;
    }

    public long GetNext() {
        return this.next_;
    }

    public void SetNext(long next) {
        this.next_ = next;
    }

    public long GetChild() {
        return this.child_;
    }

    public void SetChild(long child) {
        this.child_ = child;
    }

    public void SetAddress(long address) {
        this.address_ = address;
    }

    public long GetAddress() {
        return this.address_;
    }

    public void WriteData(RandomAccessFile raf) throws IOException {
    }

    public void ReadData(RandomAccessFile raf) throws IOException {
    }

    public static PersistentTreeNode GetNode(RandomAccessFile raf, long address) throws IOException {
        PersistentTreeNode node = new PersistentTreeNode(address);
        raf.seek(address);
        int level = raf.readInt();
        long next = raf.readLong();
        long parent = raf.readLong();
        long child = raf.readLong();
        node.ReadData(raf);
        node.SetLevel(level);
        node.SetParent(parent);
        node.SetNext(next);
        node.SetChild(child);
        return node;
    }

    public static void PrintNode(RandomAccessFile raf, long address) throws IOException {
        PersistentTreeNode curNode = PersistentTreeNode.GetNode(raf, address);
        System.out.print("--");
        for (int i = 0; i < curNode.GetLevel(); ++i) {
            System.out.print("---");
        }
        System.out.print(" (" + curNode.GetAddress() + ")");
        System.out.print(System.getProperty("line.separator").toString());
        long childAddress = curNode.GetChild();
        while (childAddress != -1L) {
            PersistentTreeNode childNode = PersistentTreeNode.GetNode(raf, childAddress);
            PersistentTreeNode.PrintNode(raf, childAddress);
            childAddress = childNode.GetNext();
        }
    }
}

