/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.CombineRecords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToUninflectTerm
extends Transformation {
    private static final String INFO = "Uninflect Term";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> outs1 = ToUninflectTerm.UninflectTerm(in, conn, trie, INFO, detailsFlag, mutateFlag);
        Vector<LexItem> outs = CombineRecords.Combine(outs1, 2);
        return outs;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToUninflectTerm.GetTestStr(args, "Left Data");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToUninflectTerm.Mutate(in, conn, trie, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToUninflectTerm.PrintResults(in, outs);
    }

    protected static Vector<LexItem> UninflectTerm(LexItem in, Connection conn, RamTrie trie, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        try {
            Vector<InflectionRecord> factList = DbUninflection.GetUninflections(inStr, conn);
            for (int i = 0; i < factList.size(); ++i) {
                long curInfl;
                InflectionRecord record = factList.elementAt(i);
                String uninflectedTerm = record.GetUninflectedTerm();
                long curCat = record.GetCategory();
                if (!InputFilter.IsLegal(inCat, inInfl, curCat, curInfl = record.GetInflection())) continue;
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (FACT)";
                }
                if (mutateFlag) {
                    String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                    mutate = "FACT" + fs + record.GetInflectedTerm() + fs + Category.ToName(record.GetCategory()) + fs + Inflection.ToName(record.GetInflection()) + fs + uninflectedTerm + fs + Category.ToName(record.GetCategory()) + fs + "base" + fs + record.GetEui() + fs;
                }
                LexItem temp = ToUninflectTerm.UpdateLexItem(in, uninflectedTerm, 13, curCat, Inflection.GetBitValue(0), details, mutate);
                out.addElement(temp);
            }
            if (out.size() == 0) {
                Vector<RuleResult> ruleList = trie.GetUninflectedTermsByRules(inStr, inCat, inInfl, true);
                for (int i = 0; i < ruleList.size(); ++i) {
                    LexItem temp;
                    RuleResult result = ruleList.elementAt(i);
                    String uninflectedTerm = result.GetOutTerm();
                    long outCat = Category.ToValue(result.GetOutCategory());
                    long outInfl = Inflection.ToValue(result.GetOutInflection());
                    String details = null;
                    String mutate = null;
                    if (detailsFlag) {
                        details = infoStr + " (RULE)";
                    }
                    if (mutateFlag) {
                        mutate = "RULE" + GlobalBehavior.GetInstance().GetFieldSeparator() + result.GetRuleString();
                    }
                    if (out.contains(temp = ToUninflectTerm.UpdateLexItem(in, uninflectedTerm, 13, outCat, outInfl, details, mutate)) || DbInflection.IsExistInflectedTerm(uninflectedTerm, conn)) continue;
                    out.addElement(temp);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }
}

