/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbCitation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToNormUninflectWords
extends Transformation {
    private static final String INFO = "Normalize Uninflect Words";

    public static Vector<LexItem> Mutate(LexItem in, int maxTerm, Connection conn, RamTrie trie, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<String> termList = ToNormUninflectWords.NormUninflectWords(in.GetSourceTerm(), maxTerm, conn, trie);
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < termList.size(); ++i) {
            String term = termList.elementAt(i);
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            LexItem temp = ToNormUninflectWords.UpdateLexItem(in, term, 39, 2047L, Inflection.GetBitValue(0), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToNormUninflectWords.GetTestStr(args, "Color colour");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int maxTerm = Integer.parseInt(conf.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToNormUninflectWords.Mutate(in, maxTerm, conn, trie, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToNormUninflectWords.PrintResults(in, outs);
    }

    private static Vector<String> NormUninflectWords(String inStr, int maxTerm, Connection conn, RamTrie trie) {
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        Vector<String> out = new Vector();
        Vector<Vector<String>> strList = new Vector<Vector<String>>();
        long totalNum = 1L;
        while (buf.hasMoreTokens()) {
            String curStr = buf.nextToken();
            try {
                Vector<InflectionRecord> factList = DbCitation.GetCitations(curStr, conn);
                Vector<String> wordList = new Vector<String>();
                for (int i = 0; i < factList.size(); ++i) {
                    InflectionRecord record = factList.elementAt(i);
                    String citationTerm = record.GetCitationTerm();
                    String citationTermLc = citationTerm.toLowerCase();
                    if (wordList.contains(citationTermLc)) continue;
                    wordList.addElement(citationTermLc);
                }
                if (factList.size() == 0) {
                    Vector<RuleResult> ruleList = trie.GetUninflectedTermsByRules(curStr, 2047L, 0xFFFFFFL, true);
                    String smallestStr = null;
                    for (int i = 0; i < ruleList.size(); ++i) {
                        RuleResult result = ruleList.elementAt(i);
                        String uninflectedTerm = result.GetOutTerm();
                        String uninflectedTermLc = uninflectedTerm.toLowerCase();
                        if (DbUninflection.IsExistUninflectedTerm(uninflectedTermLc, conn)) continue;
                        if (smallestStr == null) {
                            smallestStr = uninflectedTermLc;
                            continue;
                        }
                        if (uninflectedTermLc.compareTo(smallestStr) >= 0 || DbUninflection.IsExistUninflectedTerm(uninflectedTerm, conn)) continue;
                        smallestStr = uninflectedTermLc;
                    }
                    wordList.addElement(smallestStr);
                }
                if ((totalNum *= (long)wordList.size()) > (long)maxTerm) {
                    out.removeAllElements();
                    out.addElement(inStr);
                    return out;
                }
                strList.addElement(wordList);
            }
            catch (Exception e) {
                break;
            }
        }
        out = ToUninflectWords.FormCombinations(strList);
        if (strList.size() >= 1) {
            LvgComparator lc = new LvgComparator();
            lc.SetLengthFlag(true);
            lc.SetCase(false);
            Collections.sort(out, lc);
        }
        return out;
    }
}

